/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.db.migration.version.v65;

import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;
import org.sonar.api.utils.System2;
import org.sonar.db.Database;
import org.sonar.server.platform.db.migration.step.DataChange;
import org.sonar.server.platform.db.migration.step.MassUpdate;
import org.sonar.server.platform.db.migration.step.Select;
import org.sonar.server.platform.db.migration.step.SqlStatement;

public class PopulateTableDefaultQProfiles
extends DataChange {
    private final System2 system2;

    public PopulateTableDefaultQProfiles(Database db, System2 system2) {
        super(db);
        this.system2 = system2;
    }

    @Override
    protected void execute(DataChange.Context context) throws SQLException {
        Set<OrgLang> buggyOrgs = PopulateTableDefaultQProfiles.selectOrgsWithMultipleDefaultProfiles(context);
        HashSet processedBuggyOrgs = new HashSet();
        long now = this.system2.now();
        MassUpdate massUpdate = context.prepareMassUpdate();
        massUpdate.select("select p.organization_uuid, p.language, p.kee from rules_profiles p  where p.is_default = ?  and not exists (select 1 from default_qprofiles dp where dp.organization_uuid = p.organization_uuid and dp.language = p.language) order by id").setBoolean(1, true);
        massUpdate.update("insert into default_qprofiles (organization_uuid, language, qprofile_uuid, created_at, updated_at) values (?, ?, ?, ?, ?)");
        massUpdate.rowPluralName("default_qprofiles");
        massUpdate.execute((Select.Row row, SqlStatement update) -> {
            OrgLang pk = new OrgLang(row.getString(1), row.getString(2));
            String profileUuid = row.getString(3);
            boolean isBuggy = buggyOrgs.contains(pk);
            if (isBuggy && processedBuggyOrgs.contains(pk)) {
                return false;
            }
            update.setString(1, pk.orgUuid);
            update.setString(2, pk.language);
            update.setString(3, profileUuid);
            update.setLong(4, now);
            update.setLong(5, now);
            if (isBuggy) {
                processedBuggyOrgs.add(pk);
            }
            return true;
        });
    }

    private static Set<OrgLang> selectOrgsWithMultipleDefaultProfiles(DataChange.Context context) throws SQLException {
        Select rows = (Select)context.prepareSelect("select organization_uuid, language from rules_profiles  where is_default = ?  group by organization_uuid, language  having count(kee) > 1 ").setBoolean(1, true);
        return new HashSet<OrgLang>(rows.list(row -> new OrgLang(row.getString(1), row.getString(2))));
    }

    private static class OrgLang {
        private final String orgUuid;
        private final String language;

        private OrgLang(String orgUuid, String language) {
            this.orgUuid = orgUuid;
            this.language = language;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            OrgLang orgLang = (OrgLang)o;
            if (!this.orgUuid.equals(orgLang.orgUuid)) {
                return false;
            }
            return this.language.equals(orgLang.language);
        }

        public int hashCode() {
            int result = this.orgUuid.hashCode();
            result = 31 * result + this.language.hashCode();
            return result;
        }
    }
}

