/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.db.migration.version.v71;

import java.sql.Connection;
import java.sql.SQLException;
import org.sonar.db.Database;
import org.sonar.db.DatabaseUtils;
import org.sonar.server.platform.db.migration.def.BigIntegerColumnDef;
import org.sonar.server.platform.db.migration.def.IntegerColumnDef;
import org.sonar.server.platform.db.migration.def.VarcharColumnDef;
import org.sonar.server.platform.db.migration.sql.CreateIndexBuilder;
import org.sonar.server.platform.db.migration.sql.CreateTableBuilder;
import org.sonar.server.platform.db.migration.step.DdlChange;

public class CreateDeprecatedRuleKeysTable
extends DdlChange {
    private static final String DEPRECATED_RULE_KEYS = "deprecated_rule_keys";
    private static final VarcharColumnDef UUID_COLUMN = VarcharColumnDef.newVarcharColumnDefBuilder().setColumnName("uuid").setIsNullable(false).setLimit(40).build();
    private static final IntegerColumnDef RULE_ID_COLUMN = IntegerColumnDef.newIntegerColumnDefBuilder().setColumnName("rule_id").setIsNullable(false).build();
    private static final VarcharColumnDef OLD_REPOSITORY_KEY_COLUMN = VarcharColumnDef.newVarcharColumnDefBuilder().setColumnName("old_repository_key").setIsNullable(false).setLimit(255).build();
    private static final VarcharColumnDef OLD_RULE_KEY_COLUMN = VarcharColumnDef.newVarcharColumnDefBuilder().setColumnName("old_rule_key").setIsNullable(false).setLimit(200).build();
    private static final BigIntegerColumnDef CREATED_AT_COLUMN = BigIntegerColumnDef.newBigIntegerColumnDefBuilder().setColumnName("created_at").setIsNullable(false).build();
    private Database db;

    public CreateDeprecatedRuleKeysTable(Database db) {
        super(db);
        this.db = db;
    }

    @Override
    public void execute(DdlChange.Context context) throws SQLException {
        if (!this.tableExists()) {
            context.execute(new CreateTableBuilder(this.getDialect(), DEPRECATED_RULE_KEYS).addPkColumn(UUID_COLUMN, new CreateTableBuilder.ColumnFlag[0]).addColumn(RULE_ID_COLUMN).addColumn(OLD_REPOSITORY_KEY_COLUMN).addColumn(OLD_RULE_KEY_COLUMN).addColumn(CREATED_AT_COLUMN).build());
            context.execute(new CreateIndexBuilder(this.getDialect()).setTable(DEPRECATED_RULE_KEYS).addColumn(OLD_REPOSITORY_KEY_COLUMN).addColumn(OLD_RULE_KEY_COLUMN).setUnique(true).setName("uniq_deprecated_rule_keys").build());
            context.execute(new CreateIndexBuilder(this.getDialect()).setTable(DEPRECATED_RULE_KEYS).addColumn(RULE_ID_COLUMN).setUnique(true).setName("rule_id_deprecated_rule_keys").build());
        }
    }

    private boolean tableExists() throws SQLException {
        try (Connection connection = this.db.getDataSource().getConnection();){
            boolean bl = DatabaseUtils.tableExists((String)DEPRECATED_RULE_KEYS, (Connection)connection);
            return bl;
        }
    }
}

