/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.db.migration.version.v71;

import com.google.common.collect.Multimap;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.core.util.UuidFactory;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.Database;
import org.sonar.server.platform.db.migration.step.DataChange;
import org.sonar.server.platform.db.migration.step.Select;
import org.sonar.server.platform.db.migration.step.Upsert;
import org.sonar.server.platform.db.migration.version.v63.DefaultOrganizationUuidProvider;

public class MigrateWebhooksToWebhooksTable
extends DataChange {
    private static final long NO_RESOURCE_ID = -8435121L;
    private static final Logger LOGGER = Loggers.get(MigrateWebhooksToWebhooksTable.class);
    private DefaultOrganizationUuidProvider defaultOrganizationUuidProvider;
    private UuidFactory uuidFactory;

    public MigrateWebhooksToWebhooksTable(Database db, DefaultOrganizationUuidProvider defaultOrganizationUuidProvider, UuidFactory uuidFactory) {
        super(db);
        this.defaultOrganizationUuidProvider = defaultOrganizationUuidProvider;
        this.uuidFactory = uuidFactory;
    }

    @Override
    public void execute(DataChange.Context context) throws SQLException {
        Multimap rows = (Multimap)((Select)((Select)((Select)context.prepareSelect("select props.id, props.prop_key, props.resource_id, prj.uuid, props.text_value, props.created_at from properties props left join projects prj on prj.id = props.resource_id and prj.scope = ? and prj.qualifier = ? and prj.enabled = ? where props.prop_key like 'sonar.webhooks%' and props.text_value is not null").setString(1, "PRJ")).setString(2, "TRK")).setBoolean(3, true)).list(row -> new PropertyRow(row.getLong(1), row.getString(2), row.getNullableLong(3), row.getNullableString(4), row.getString(5), row.getLong(6))).stream().collect(MoreCollectors.index(PropertyRow::getResourceId, Function.identity()));
        for (Map.Entry entry : rows.asMap().entrySet()) {
            long projectId = (Long)entry.getKey();
            if (projectId == -8435121L) {
                this.migrateGlobalWebhooks(context, (Collection)entry.getValue());
            } else {
                this.migrateProjectsWebhooks(context, (Collection)entry.getValue());
            }
            MigrateWebhooksToWebhooksTable.deleteAllWebhookProperties(context);
        }
    }

    private static void deleteAllWebhookProperties(DataChange.Context context) throws SQLException {
        context.prepareUpsert("delete from properties where prop_key like 'sonar.webhooks.global%' or prop_key like 'sonar.webhooks.project%'").execute().commit();
    }

    private void migrateGlobalWebhooks(DataChange.Context context, Collection<PropertyRow> rows) throws SQLException {
        Multimap rowsByPropertyKey = (Multimap)rows.stream().collect(MoreCollectors.index(PropertyRow::getPropertyKey));
        Optional rootProperty = rowsByPropertyKey.get((Object)"sonar.webhooks.global").stream().findFirst();
        if (rootProperty.isPresent()) {
            PropertyRow row = (PropertyRow)rootProperty.get();
            for (Webhook webhook : this.extractGlobalWebhooksFrom(context, (Multimap<String, PropertyRow>)rowsByPropertyKey, row.value().split(","))) {
                this.insert(context, webhook);
            }
        }
    }

    private List<Webhook> extractGlobalWebhooksFrom(DataChange.Context context, Multimap<String, PropertyRow> rowsByPropertyKey, String[] values) throws SQLException {
        String defaultOrganizationUuid = this.defaultOrganizationUuidProvider.get(context);
        return Arrays.stream(values).map(value -> {
            Optional name = rowsByPropertyKey.get((Object)("sonar.webhooks.global." + value + ".name")).stream().findFirst();
            Optional url = rowsByPropertyKey.get((Object)("sonar.webhooks.global." + value + ".url")).stream().findFirst();
            if (name.isPresent() && url.isPresent()) {
                return new Webhook((PropertyRow)name.get(), (PropertyRow)url.get(), defaultOrganizationUuid, null);
            }
            LOGGER.warn("Global webhook missing name and/or url will be deleted (name='{}', url='{}')", name.map(PropertyRow::value).orElse(null), url.map(PropertyRow::value).orElse(null));
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private void migrateProjectsWebhooks(DataChange.Context context, Collection<PropertyRow> rows) throws SQLException {
        Multimap rowsByPropertyKey = (Multimap)rows.stream().collect(MoreCollectors.index(PropertyRow::getPropertyKey));
        Optional rootProperty = rowsByPropertyKey.get((Object)"sonar.webhooks.project").stream().findFirst();
        if (rootProperty.isPresent()) {
            PropertyRow row = (PropertyRow)rootProperty.get();
            if (row.getProjectUuid() == null) {
                LOGGER.warn("At least one webhook referenced missing or non project resource '{}' and will be deleted", (Object)row.getResourceId());
            } else {
                for (Webhook webhook : MigrateWebhooksToWebhooksTable.extractProjectWebhooksFrom(row, (Multimap<String, PropertyRow>)rowsByPropertyKey, row.value().split(","))) {
                    this.insert(context, webhook);
                }
            }
        }
    }

    private static List<Webhook> extractProjectWebhooksFrom(PropertyRow row, Multimap<String, PropertyRow> properties, String[] values) {
        return (List)Arrays.stream(values).map(value -> {
            Optional name = properties.get((Object)("sonar.webhooks.project." + value + ".name")).stream().findFirst();
            Optional url = properties.get((Object)("sonar.webhooks.project." + value + ".url")).stream().findFirst();
            if (name.isPresent() && url.isPresent()) {
                return new Webhook((PropertyRow)name.get(), (PropertyRow)url.get(), null, row.projectUuid);
            }
            LOGGER.warn("Project webhook for project {} (id={}) missing name and/or url will be deleted (name='{}', url='{}')", new Object[]{row.getProjectUuid(), row.getResourceId(), name.map(PropertyRow::value).orElse(null), url.map(PropertyRow::value).orElse(null)});
            return null;
        }).filter(Objects::nonNull).collect(MoreCollectors.toList());
    }

    private void insert(DataChange.Context context, Webhook webhook) throws SQLException {
        if (webhook.isValid()) {
            ((Upsert)((Upsert)((Upsert)((Upsert)((Upsert)((Upsert)((Upsert)context.prepareUpsert("insert into webhooks (uuid, name, url, organization_uuid, project_uuid, created_at, updated_at) values (?, ?, ?, ?, ?, ?, ?)").setString(1, this.uuidFactory.create())).setString(2, webhook.name())).setString(3, webhook.url())).setString(4, webhook.organisationUuid())).setString(5, webhook.projectUuid())).setLong(6, webhook.createdAt())).setLong(7, webhook.createdAt())).execute().commit();
        } else {
            LOGGER.info("Unable to migrate inconsistent webhook (entry deleted from PROPERTIES) : " + webhook);
        }
    }

    private static class Webhook {
        private final PropertyRow name;
        private final PropertyRow url;
        private String organisationUuid;
        private String projectUuid;

        public Webhook(@Nullable PropertyRow name, @Nullable PropertyRow url, @Nullable String organisationUuid, @Nullable String projectUuid) {
            this.name = name;
            this.url = url;
            this.organisationUuid = organisationUuid;
            this.projectUuid = projectUuid;
        }

        public String name() {
            return this.name.value();
        }

        public String url() {
            return this.url.value();
        }

        public String organisationUuid() {
            return this.organisationUuid;
        }

        public String projectUuid() {
            return this.projectUuid;
        }

        public Long createdAt() {
            return this.name.createdAt();
        }

        public boolean isValid() {
            return this.name != null && this.url != null && this.name() != null && this.url() != null && (this.organisationUuid() != null || this.projectUuid() != null) && this.createdAt() != null;
        }

        public String toString() {
            StringBuilder s = new StringBuilder().append("Webhook{").append("name=").append(this.name);
            if (this.name != null) {
                s.append(this.name.toString());
            }
            s.append(", url=").append(this.url);
            if (this.url != null) {
                s.append(this.url.toString());
            }
            s.append(", organisationUuid='").append(this.organisationUuid).append('\'').append(", projectUuid='").append(this.projectUuid).append('\'').append('}');
            return s.toString();
        }
    }

    private static class PropertyRow {
        private final Long id;
        private final String propertyKey;
        private final Long resourceId;
        private final String projectUuid;
        private final String value;
        private final Long createdAt;

        private PropertyRow(long id, String propertyKey, @Nullable Long resourceId, @Nullable String projectUuid, String value, Long createdAt) {
            this.id = id;
            this.propertyKey = propertyKey;
            this.resourceId = resourceId;
            this.projectUuid = projectUuid;
            this.value = value;
            this.createdAt = createdAt;
        }

        public Long id() {
            return this.id;
        }

        public String getPropertyKey() {
            return this.propertyKey;
        }

        public long getResourceId() {
            return this.resourceId == null ? -8435121L : this.resourceId;
        }

        @CheckForNull
        public String getProjectUuid() {
            return this.projectUuid;
        }

        public String value() {
            return this.value;
        }

        public Long createdAt() {
            return this.createdAt;
        }

        public String toString() {
            return "{id=" + this.id + ", propertyKey='" + this.propertyKey + '\'' + ", resourceId=" + this.resourceId + ", projectUuid=" + this.projectUuid + ", value='" + this.value + '\'' + ", createdAt=" + this.createdAt + '}';
        }
    }
}

