/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.db.migration.version.v72;

import java.sql.Connection;
import java.sql.SQLException;
import org.sonar.db.Database;
import org.sonar.db.DatabaseUtils;
import org.sonar.server.platform.db.migration.def.BigIntegerColumnDef;
import org.sonar.server.platform.db.migration.def.VarcharColumnDef;
import org.sonar.server.platform.db.migration.sql.CreateIndexBuilder;
import org.sonar.server.platform.db.migration.sql.CreateTableBuilder;
import org.sonar.server.platform.db.migration.step.DdlChange;

public class CreateAlmAppInstallsTable
extends DdlChange {
    private static final String TABLE_NAME = "alm_app_installs";
    private static final VarcharColumnDef UUID = VarcharColumnDef.newVarcharColumnDefBuilder().setColumnName("uuid").setLimit(40).setIsNullable(false).build();
    private static final VarcharColumnDef ALM_ID_COLUMN = VarcharColumnDef.newVarcharColumnDefBuilder().setColumnName("alm_id").setIsNullable(false).setLimit(40).build();
    private static final VarcharColumnDef OWNER_COLUMN = VarcharColumnDef.newVarcharColumnDefBuilder().setColumnName("owner_id").setIsNullable(false).setLimit(4000).build();
    private static final VarcharColumnDef INSTALL_COLUMN = VarcharColumnDef.newVarcharColumnDefBuilder().setColumnName("install_id").setIsNullable(false).setLimit(4000).build();
    private static final BigIntegerColumnDef CREATED_AT_COLUMN = BigIntegerColumnDef.newBigIntegerColumnDefBuilder().setColumnName("created_at").setIsNullable(false).build();
    private static final BigIntegerColumnDef UPDATED_AT_COLUMN = BigIntegerColumnDef.newBigIntegerColumnDefBuilder().setColumnName("updated_at").setIsNullable(false).build();

    public CreateAlmAppInstallsTable(Database db) {
        super(db);
    }

    @Override
    public void execute(DdlChange.Context context) throws SQLException {
        if (!this.tableExists()) {
            context.execute(new CreateTableBuilder(this.getDialect(), TABLE_NAME).addPkColumn(UUID, new CreateTableBuilder.ColumnFlag[0]).addColumn(ALM_ID_COLUMN).addColumn(OWNER_COLUMN).addColumn(INSTALL_COLUMN).addColumn(CREATED_AT_COLUMN).addColumn(UPDATED_AT_COLUMN).build());
            context.execute(new CreateIndexBuilder(this.getDialect()).addColumn(ALM_ID_COLUMN).addColumn(OWNER_COLUMN).setUnique(true).setTable(TABLE_NAME).setName("alm_app_installs_owner").build());
            context.execute(new CreateIndexBuilder(this.getDialect()).addColumn(ALM_ID_COLUMN).addColumn(INSTALL_COLUMN).setUnique(true).setTable(TABLE_NAME).setName("alm_app_installs_install").build());
        }
    }

    private boolean tableExists() throws SQLException {
        try (Connection connection = this.getDatabase().getDataSource().getConnection();){
            boolean bl = DatabaseUtils.tableExists((String)TABLE_NAME, (Connection)connection);
            return bl;
        }
    }
}

