/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.db.migration.version.v73;

import java.sql.SQLException;
import java.util.Date;
import org.sonar.api.utils.System2;
import org.sonar.db.Database;
import org.sonar.server.platform.db.migration.SupportsBlueGreen;
import org.sonar.server.platform.db.migration.step.DataChange;
import org.sonar.server.platform.db.migration.step.MassUpdate;
import org.sonar.server.platform.db.migration.step.Select;
import org.sonar.server.platform.db.migration.step.SqlStatement;

@SupportsBlueGreen
public class PopulateHotspotAdminPermissionOnTemplatesUsers
extends DataChange {
    private static final String ISSUE_ADMIN_ROLE = "issueadmin";
    private static final String HOTSPOT_ADMIN_ROLE = "securityhotspotadmin";
    private final System2 system2;

    public PopulateHotspotAdminPermissionOnTemplatesUsers(Database db, System2 system2) {
        super(db);
        this.system2 = system2;
    }

    @Override
    protected void execute(DataChange.Context context) throws SQLException {
        Date now = new Date(this.system2.now());
        MassUpdate massUpdate = context.prepareMassUpdate();
        massUpdate.select("SELECT user_id, template_id  FROM perm_templates_users u1  WHERE permission_reference = ?  AND NOT EXISTS (    SELECT id    FROM perm_templates_users u2    WHERE permission_reference = ?    AND u1.user_id = u2.user_id    AND u1.template_id = u2.template_id)").setString(1, ISSUE_ADMIN_ROLE).setString(2, HOTSPOT_ADMIN_ROLE);
        massUpdate.update("INSERT INTO perm_templates_users (user_id, template_id, permission_reference, created_at, updated_at) values (?,?,?,?,?)");
        massUpdate.rowPluralName("permission templates users roles");
        massUpdate.execute((Select.Row row, SqlStatement update) -> PopulateHotspotAdminPermissionOnTemplatesUsers.handle(row, update, now));
    }

    private static boolean handle(Select.Row row, SqlStatement update, Date now) throws SQLException {
        int userId = row.getInt(1);
        int templateId = row.getInt(2);
        update.setInt(1, userId);
        update.setInt(2, templateId);
        update.setString(3, HOTSPOT_ADMIN_ROLE);
        update.setDate(4, now);
        update.setDate(5, now);
        return true;
    }
}

