/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.db.migration.version.v73;

import java.sql.SQLException;
import org.sonar.db.Database;
import org.sonar.server.platform.db.migration.SupportsBlueGreen;
import org.sonar.server.platform.db.migration.step.DataChange;
import org.sonar.server.platform.db.migration.step.MassUpdate;
import org.sonar.server.platform.db.migration.step.Select;
import org.sonar.server.platform.db.migration.step.SqlStatement;

@SupportsBlueGreen
public class PopulateHotspotAdminPermissionOnUsers
extends DataChange {
    private static final String ISSUE_ADMIN_ROLE = "issueadmin";
    private static final String HOTSPOT_ADMIN_ROLE = "securityhotspotadmin";

    public PopulateHotspotAdminPermissionOnUsers(Database db) {
        super(db);
    }

    @Override
    protected void execute(DataChange.Context context) throws SQLException {
        MassUpdate massUpdate = context.prepareMassUpdate();
        massUpdate.select("SELECT user_id, resource_id, organization_uuid  FROM user_roles ur1  WHERE role = ?  AND NOT EXISTS (    SELECT id    FROM user_roles ur2    WHERE role = ?    AND ur1.user_id = ur2.user_id    AND ur1.resource_id = ur2.resource_id    AND ur1.organization_uuid = ur2.organization_uuid)").setString(1, ISSUE_ADMIN_ROLE).setString(2, HOTSPOT_ADMIN_ROLE);
        massUpdate.update("INSERT INTO user_roles (user_id, resource_id, organization_uuid, role) values (?,?,?,?)");
        massUpdate.rowPluralName("user roles");
        massUpdate.execute(PopulateHotspotAdminPermissionOnUsers::handle);
    }

    private static boolean handle(Select.Row row, SqlStatement update) throws SQLException {
        int userId = row.getInt(1);
        int resourceId = row.getInt(2);
        String organizationUuid = row.getString(3);
        update.setInt(1, userId);
        update.setInt(2, resourceId);
        update.setString(3, organizationUuid);
        update.setString(4, HOTSPOT_ADMIN_ROLE);
        return true;
    }
}

