/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.db.migration.version.v74;

import java.sql.SQLException;
import org.sonar.api.config.Configuration;
import org.sonar.db.Database;
import org.sonar.server.platform.db.migration.SupportsBlueGreen;
import org.sonar.server.platform.db.migration.step.DataChange;
import org.sonar.server.platform.db.migration.step.MassUpdate;
import org.sonar.server.platform.db.migration.step.Select;
import org.sonar.server.platform.db.migration.step.SqlStatement;

@SupportsBlueGreen
public class CleanOrphanRowsInCeTables
extends DataChange {
    private final Configuration configuration;

    public CleanOrphanRowsInCeTables(Database db, Configuration configuration1) {
        super(db);
        this.configuration = configuration1;
    }

    @Override
    protected void execute(DataChange.Context context) throws SQLException {
        if (CleanOrphanRowsInCeTables.isSonarCloud(this.configuration)) {
            return;
        }
        MassUpdate massUpdate = context.prepareMassUpdate();
        massUpdate.select("select  cea.uuid from ce_activity cea where   cea.component_uuid is not null   and cea.main_component_uuid is not null   and cea.component_uuid = cea.main_component_uuid   and exists (select 1 from ce_task_characteristics ctc where ctc.task_uuid = cea.uuid)");
        massUpdate.update("delete from ce_task_input where task_uuid = ?");
        massUpdate.update("delete from ce_scanner_context where task_uuid = ?");
        massUpdate.update("delete from ce_task_characteristics where task_uuid = ?");
        massUpdate.update("delete from ce_activity where uuid = ?");
        massUpdate.rowPluralName("orphans of deleted branch/pr");
        massUpdate.execute((Select.Row row, SqlStatement update, int updateIndex) -> {
            String taskUuid = row.getString(1);
            update.setString(1, taskUuid);
            return true;
        });
    }
}

