/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.db.migration.version.v75;

import java.sql.Connection;
import java.sql.SQLException;
import org.sonar.db.Database;
import org.sonar.db.DatabaseUtils;
import org.sonar.server.platform.db.migration.SupportsBlueGreen;
import org.sonar.server.platform.db.migration.def.BigIntegerColumnDef;
import org.sonar.server.platform.db.migration.def.VarcharColumnDef;
import org.sonar.server.platform.db.migration.sql.CreateIndexBuilder;
import org.sonar.server.platform.db.migration.sql.CreateTableBuilder;
import org.sonar.server.platform.db.migration.step.DdlChange;

@SupportsBlueGreen
public class CreateOrganizationsAlmBindingsTable
extends DdlChange {
    private static final String TABLE_NAME = "organization_alm_bindings";
    private static final VarcharColumnDef UUID_COLUMN = VarcharColumnDef.newVarcharColumnDefBuilder().setColumnName("uuid").setIsNullable(false).setLimit(40).build();
    private static final VarcharColumnDef ORGANIZATION_UUID_COLUMN = VarcharColumnDef.newVarcharColumnDefBuilder().setColumnName("organization_uuid").setIsNullable(false).setLimit(40).build();
    private static final VarcharColumnDef ALM_APP_INSTALL_UUID_COLUMN = VarcharColumnDef.newVarcharColumnDefBuilder().setColumnName("alm_app_install_uuid").setIsNullable(false).setLimit(40).build();
    private static final VarcharColumnDef ALM_ID_COLUMN = VarcharColumnDef.newVarcharColumnDefBuilder().setColumnName("alm_id").setIsNullable(false).setLimit(40).build();
    private static final VarcharColumnDef URL_COLUMN = VarcharColumnDef.newVarcharColumnDefBuilder().setColumnName("url").setIsNullable(false).setLimit(2000).build();
    private static final VarcharColumnDef USER_UUID_COLUMN = VarcharColumnDef.newVarcharColumnDefBuilder().setColumnName("user_uuid").setIsNullable(false).setLimit(255).build();
    private static final BigIntegerColumnDef CREATED_AT_COLUMN = BigIntegerColumnDef.newBigIntegerColumnDefBuilder().setColumnName("created_at").setIsNullable(false).build();

    public CreateOrganizationsAlmBindingsTable(Database db) {
        super(db);
    }

    @Override
    public void execute(DdlChange.Context context) throws SQLException {
        if (!this.tableExists()) {
            context.execute(new CreateTableBuilder(this.getDialect(), TABLE_NAME).addPkColumn(UUID_COLUMN, new CreateTableBuilder.ColumnFlag[0]).addColumn(ORGANIZATION_UUID_COLUMN).addColumn(ALM_APP_INSTALL_UUID_COLUMN).addColumn(ALM_ID_COLUMN).addColumn(URL_COLUMN).addColumn(USER_UUID_COLUMN).addColumn(CREATED_AT_COLUMN).build());
            context.execute(new CreateIndexBuilder(this.getDialect()).addColumn(ORGANIZATION_UUID_COLUMN).setUnique(true).setTable(TABLE_NAME).setName("org_alm_bindings_org").build());
            context.execute(new CreateIndexBuilder(this.getDialect()).addColumn(ALM_APP_INSTALL_UUID_COLUMN).setUnique(true).setTable(TABLE_NAME).setName("org_alm_bindings_install").build());
        }
    }

    private boolean tableExists() throws SQLException {
        try (Connection connection = this.getDatabase().getDataSource().getConnection();){
            boolean bl = DatabaseUtils.tableExists((String)TABLE_NAME, (Connection)connection);
            return bl;
        }
    }
}

