/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.db.migration.version.v76;

import java.sql.SQLException;
import org.sonar.api.config.Configuration;
import org.sonar.db.Database;
import org.sonar.server.platform.db.migration.SupportsBlueGreen;
import org.sonar.server.platform.db.migration.step.DataChange;
import org.sonar.server.platform.db.migration.step.MassUpdate;
import org.sonar.server.platform.db.migration.step.Select;
import org.sonar.server.platform.db.migration.step.SqlStatement;

@SupportsBlueGreen
public class DeleteModuleAndFolderMeasures
extends DataChange {
    private final Configuration configuration;

    public DeleteModuleAndFolderMeasures(Database db, Configuration configuration) {
        super(db);
        this.configuration = configuration;
    }

    @Override
    public void execute(DataChange.Context context) throws SQLException {
        if (DeleteModuleAndFolderMeasures.isSonarCloud(this.configuration)) {
            return;
        }
        MassUpdate massUpdate = context.prepareMassUpdate().rowPluralName("components");
        massUpdate.select("SELECT p.uuid FROM projects p WHERE p.qualifier in ('DIR', 'BRC') AND exists(SELECT 1 FROM project_measures m WHERE m.component_uuid = p.uuid)");
        massUpdate.update("DELETE FROM project_measures WHERE component_uuid=?").setBatchSize(10);
        massUpdate.execute((Select.Row row, SqlStatement update) -> {
            String componentUuid = row.getString(1);
            update.setString(1, componentUuid);
            return true;
        });
    }
}

