/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.component;

import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.batch.fs.internal.DefaultInputFile;

public final class ComponentKeys {
    public static final int MAX_COMPONENT_KEY_LENGTH = 400;
    private static final String VALID_PROJECT_KEY_REGEXP = "[\\p{Alnum}\\-_.:]*[\\p{Alpha}\\-_.:]+[\\p{Alnum}\\-_.:]*";
    private static final String VALID_PROJECT_KEY_ISSUES_MODE_REGEXP = "[\\p{Alnum}\\-_.:/]*[\\p{Alpha}\\-_.:/]+[\\p{Alnum}\\-_.:/]*";
    private static final String VALID_BRANCH_REGEXP = "[\\p{Alnum}\\-_./]*";
    private static final String KEY_WITH_BRANCH_FORMAT = "%s:%s";

    private ComponentKeys() {
    }

    public static String createEffectiveKey(String projectKey, DefaultInputFile inputPath) {
        return ComponentKeys.createEffectiveKey(projectKey, inputPath.getProjectRelativePath());
    }

    public static String createEffectiveKey(String projectKey, @Nullable String path) {
        StringBuilder sb = new StringBuilder(400);
        sb.append(projectKey);
        if (path != null) {
            sb.append(':').append(path);
        }
        return sb.toString();
    }

    public static boolean isValidProjectKey(String keyCandidate) {
        return keyCandidate.matches(VALID_PROJECT_KEY_REGEXP);
    }

    public static void checkProjectKey(String keyCandidate) {
        Preconditions.checkArgument((boolean)ComponentKeys.isValidProjectKey(keyCandidate), (String)"Malformed key for '%s'. Allowed characters are alphanumeric, '-', '_', '.' and ':', with at least one non-digit.", (Object[])new Object[]{keyCandidate});
    }

    public static boolean isValidProjectKeyIssuesMode(String keyCandidate) {
        return keyCandidate.matches(VALID_PROJECT_KEY_ISSUES_MODE_REGEXP);
    }

    public static boolean isValidLegacyBranch(String branchCandidate) {
        return branchCandidate.matches(VALID_BRANCH_REGEXP);
    }

    public static String createKey(String keyWithoutBranch, @Nullable String branch) {
        if (StringUtils.isNotBlank((String)branch)) {
            return String.format(KEY_WITH_BRANCH_FORMAT, keyWithoutBranch, branch);
        }
        return keyWithoutBranch;
    }

    public static String createKey(String projectKey, @Nullable String path, @Nullable String branch) {
        String key = ComponentKeys.createKey(projectKey, branch);
        return ComponentKeys.createEffectiveKey(key, path);
    }
}

