/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.issue.tracking;

import com.google.common.base.MoreObjects;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import org.sonar.core.issue.tracking.Trackable;

public class Tracking<RAW extends Trackable, BASE extends Trackable> {
    protected final IdentityHashMap<RAW, BASE> rawToBase;
    protected final IdentityHashMap<BASE, RAW> baseToRaw;
    private final Collection<RAW> raws;
    private final Collection<BASE> bases;

    Tracking(Collection<RAW> rawInput, Collection<BASE> baseInput) {
        this(rawInput, baseInput, new IdentityHashMap(), new IdentityHashMap());
    }

    protected Tracking(Collection<RAW> rawInput, Collection<BASE> baseInput, IdentityHashMap<RAW, BASE> rawToBase, IdentityHashMap<BASE, RAW> baseToRaw) {
        this.raws = rawInput;
        this.bases = baseInput;
        this.rawToBase = rawToBase;
        this.baseToRaw = baseToRaw;
    }

    public Stream<RAW> getUnmatchedRaws() {
        return this.raws.stream().filter(raw -> !this.rawToBase.containsKey(raw));
    }

    public Map<RAW, BASE> getMatchedRaws() {
        return this.rawToBase;
    }

    @CheckForNull
    public BASE baseFor(RAW raw) {
        return (BASE)((Trackable)this.rawToBase.get(raw));
    }

    public Stream<BASE> getUnmatchedBases() {
        return this.bases.stream().filter(base -> !this.baseToRaw.containsKey(base));
    }

    boolean containsUnmatchedBase(BASE base) {
        return !this.baseToRaw.containsKey(base);
    }

    void match(RAW raw, BASE base) {
        if (!this.rawToBase.containsKey(raw)) {
            this.rawToBase.put(raw, base);
            this.baseToRaw.put(base, raw);
        }
    }

    public boolean isComplete() {
        return this.rawToBase.size() == this.raws.size();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("rawToBase", this.rawToBase).add("baseToRaw", this.baseToRaw).add("raws", this.raws).add("bases", this.bases).toString();
    }
}

