/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.timemachine;

import com.google.common.base.Preconditions;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.config.Configuration;
import org.sonar.api.i18n.I18n;

public class Periods {
    private final Configuration config;
    private final I18n i18n;

    public Periods(Configuration config, I18n i18n) {
        this.config = config;
        this.i18n = i18n;
    }

    @CheckForNull
    private static String convertDate(@Nullable Date date) {
        if (date != null) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy MMM dd");
            return dateFormat.format(date);
        }
        return null;
    }

    @CheckForNull
    public String label(int periodIndex) {
        String periodProperty = this.config.get("sonar.leak.period" + periodIndex).orElse(null);
        PeriodParameters periodParameters = new PeriodParameters(periodProperty);
        return this.label(periodParameters.getMode(), periodParameters.getParam(), periodParameters.getDate());
    }

    @CheckForNull
    public String abbreviation(int periodIndex) {
        String periodProperty = this.config.get("sonar.leak.period" + periodIndex).orElse(null);
        PeriodParameters periodParameters = new PeriodParameters(periodProperty);
        return this.abbreviation(periodParameters.getMode(), periodParameters.getParam(), periodParameters.getDate());
    }

    @CheckForNull
    public String label(String mode, @Nullable String param, @Nullable Date date) {
        return this.label(mode, param, Periods.convertDate(date), false);
    }

    @CheckForNull
    public String label(String mode, @Nullable String param, @Nullable String date) {
        return this.label(mode, param, date, false);
    }

    @CheckForNull
    public String abbreviation(String mode, @Nullable String param, @Nullable Date date) {
        return this.label(mode, param, Periods.convertDate(date), true);
    }

    @CheckForNull
    private String label(String mode, @Nullable String param, @Nullable String date, boolean shortLabel) {
        switch (mode) {
            case "days": {
                return this.labelForDays(param, date, shortLabel);
            }
            case "version": {
                return this.labelForVersion(param, date, shortLabel);
            }
            case "previous_version": {
                return this.labelForPreviousVersion(param, date, shortLabel);
            }
            case "date": {
                return this.label("since_x", shortLabel, date);
            }
        }
        throw new IllegalArgumentException("This mode is not supported : " + mode);
    }

    private String labelForDays(@Nullable String param, @Nullable String date, boolean shortLabel) {
        if (date == null) {
            return this.label("over_x_days", shortLabel, param);
        }
        return this.label("over_x_days_detailed", shortLabel, param, date);
    }

    private String labelForVersion(@Nullable String param, @Nullable String date, boolean shortLabel) {
        if (date == null) {
            return this.label("since_version", shortLabel, param);
        }
        return this.label("since_version_detailed", shortLabel, param, date);
    }

    private String labelForPreviousVersion(@Nullable String param, @Nullable String date, boolean shortLabel) {
        if (param == null && date == null) {
            return this.label("since_previous_version", shortLabel, new Object[0]);
        }
        if (param == null) {
            return this.label("since_previous_version_with_only_date", shortLabel, date);
        }
        if (date == null) {
            return this.label("since_previous_version_detailed", shortLabel, param);
        }
        return this.label("since_previous_version_detailed", shortLabel, param, date);
    }

    private String label(String key, boolean shortLabel, Object ... parameters) {
        String msgKey = key;
        if (shortLabel) {
            msgKey = msgKey + ".short";
        }
        return this.i18n.message(Locale.ENGLISH, msgKey, null, parameters);
    }

    private static class PeriodParameters {
        private String mode = null;
        private String param = null;
        private Date date = null;

        public PeriodParameters(String periodProperty) {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)periodProperty), (Object)"Period property should not be empty");
            Integer possibleDaysValue = PeriodParameters.findByDays(periodProperty);
            Date possibleDatesValue = PeriodParameters.findByDate(periodProperty);
            if ("previous_version".equals(periodProperty)) {
                this.mode = periodProperty;
            } else if (possibleDaysValue != null) {
                this.mode = "days";
                this.param = Integer.toString(possibleDaysValue);
            } else if (possibleDatesValue != null) {
                this.mode = "date";
                this.date = possibleDatesValue;
            } else {
                this.mode = "version";
                this.param = periodProperty;
            }
        }

        private static Integer findByDays(String property) {
            try {
                return Integer.parseInt(property);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }

        private static Date findByDate(String property) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            try {
                return format.parse(property);
            }
            catch (ParseException e) {
                return null;
            }
        }

        public String getMode() {
            return this.mode;
        }

        public String getParam() {
            return this.param;
        }

        public Date getDate() {
            return this.date;
        }
    }
}

