/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.util.stream;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;

public final class MoreCollectors {
    private static final int DEFAULT_HASHMAP_CAPACITY = 0;

    private MoreCollectors() {
    }

    public static <T> Collector<T, List<T>, List<T>> toList() {
        return Collector.of(ArrayList::new, List::add, (left, right) -> {
            left.addAll(right);
            return left;
        }, ImmutableList::copyOf, new Collector.Characteristics[0]);
    }

    public static <T> Collector<T, List<T>, List<T>> toList(int expectedSize) {
        return Collector.of(() -> new ArrayList(expectedSize), List::add, (left, right) -> {
            left.addAll(right);
            return left;
        }, ImmutableList::copyOf, new Collector.Characteristics[0]);
    }

    public static <T> Collector<T, Set<T>, Set<T>> toSet() {
        return Collector.of(HashSet::new, Set::add, (left, right) -> {
            left.addAll(right);
            return left;
        }, ImmutableSet::copyOf, new Collector.Characteristics[0]);
    }

    public static <T> Collector<T, Set<T>, Set<T>> toSet(int expectedSize) {
        return Collector.of(() -> new HashSet(expectedSize), Set::add, (left, right) -> {
            left.addAll(right);
            return left;
        }, ImmutableSet::copyOf, new Collector.Characteristics[0]);
    }

    public static <E extends Enum<E>> Collector<E, ?, EnumSet<E>> toEnumSet(Class<E> enumClass) {
        return Collectors.toCollection(() -> EnumSet.noneOf(enumClass));
    }

    public static <T> Collector<T, ?, ArrayList<T>> toArrayList() {
        return Collectors.toCollection(ArrayList::new);
    }

    public static <T> Collector<T, ?, ArrayList<T>> toArrayList(int size) {
        return Collectors.toCollection(() -> new ArrayList(size));
    }

    public static <T> Collector<T, ?, HashSet<T>> toHashSet() {
        return Collectors.toCollection(HashSet::new);
    }

    public static <T> Collector<T, ?, HashSet<T>> toHashSet(int size) {
        return Collectors.toCollection(() -> new HashSet(size));
    }

    public static <K, E> Collector<E, Map<K, E>, ImmutableMap<K, E>> uniqueIndex(Function<? super E, K> keyFunction) {
        return MoreCollectors.uniqueIndex(keyFunction, Function.identity());
    }

    public static <K, E> Collector<E, Map<K, E>, ImmutableMap<K, E>> uniqueIndex(Function<? super E, K> keyFunction, int expectedSize) {
        return MoreCollectors.uniqueIndex(keyFunction, Function.identity(), expectedSize);
    }

    public static <K, E, V> Collector<E, Map<K, V>, ImmutableMap<K, V>> uniqueIndex(Function<? super E, K> keyFunction, Function<? super E, V> valueFunction) {
        return MoreCollectors.uniqueIndex(keyFunction, valueFunction, 0);
    }

    public static <K, E, V> Collector<E, Map<K, V>, ImmutableMap<K, V>> uniqueIndex(Function<? super E, K> keyFunction, Function<? super E, V> valueFunction, int expectedSize) {
        Objects.requireNonNull(keyFunction, "Key function can't be null");
        Objects.requireNonNull(valueFunction, "Value function can't be null");
        BiConsumer<Map, Object> accumulator = (map, element) -> {
            Object key = Objects.requireNonNull(keyFunction.apply((Object)element), "Key function can't return null");
            Object value = Objects.requireNonNull(valueFunction.apply((Object)element), "Value function can't return null");
            MoreCollectors.putAndFailOnDuplicateKey(map, key, value);
        };
        BinaryOperator merger = (m1, m2) -> {
            for (Map.Entry entry : m2.entrySet()) {
                MoreCollectors.putAndFailOnDuplicateKey(m1, entry.getKey(), entry.getValue());
            }
            return m1;
        };
        return Collector.of(MoreCollectors.newHashMapSupplier(expectedSize), accumulator, merger, ImmutableMap::copyOf, Collector.Characteristics.UNORDERED);
    }

    public static <T> Collector<T, ?, T> toOneElement() {
        return Collectors.collectingAndThen(Collectors.toList(), list -> {
            if (list.size() != 1) {
                throw new IllegalStateException("Stream should have only one element");
            }
            return list.get(0);
        });
    }

    private static <K, V> Supplier<Map<K, V>> newHashMapSupplier(int expectedSize) {
        return () -> expectedSize == 0 ? new HashMap() : new HashMap(expectedSize);
    }

    private static <K, V> void putAndFailOnDuplicateKey(Map<K, V> map, K key, V value) {
        V existingValue = map.put(key, value);
        if (existingValue != null) {
            throw new IllegalArgumentException(String.format("Duplicate key %s", key));
        }
    }

    public static <K, E> Collector<E, ImmutableListMultimap.Builder<K, E>, ImmutableListMultimap<K, E>> index(Function<? super E, K> keyFunction) {
        return MoreCollectors.index(keyFunction, Function.identity());
    }

    public static <K, E, V> Collector<E, ImmutableListMultimap.Builder<K, V>, ImmutableListMultimap<K, V>> index(Function<? super E, K> keyFunction, Function<? super E, V> valueFunction) {
        Objects.requireNonNull(keyFunction, "Key function can't be null");
        Objects.requireNonNull(valueFunction, "Value function can't be null");
        BiConsumer<ImmutableListMultimap.Builder, Object> accumulator = (map, element) -> {
            Object key = Objects.requireNonNull(keyFunction.apply((Object)element), "Key function can't return null");
            Object value = Objects.requireNonNull(valueFunction.apply((Object)element), "Value function can't return null");
            map.put(key, value);
        };
        BinaryOperator merger = (m1, m2) -> {
            for (Map.Entry entry : m2.build().entries()) {
                m1.put(entry.getKey(), entry.getValue());
            }
            return m1;
        };
        return Collector.of(ImmutableListMultimap::builder, accumulator, merger, ImmutableListMultimap.Builder::build, new Collector.Characteristics[0]);
    }

    public static <E> Collector<E, List<E>, String> join(Joiner joiner) {
        Objects.requireNonNull(joiner, "Joiner can't be null");
        return Collector.of(ArrayList::new, List::add, MoreCollectors.mergeNotSupportedMerger(), arg_0 -> ((Joiner)joiner).join(arg_0), new Collector.Characteristics[0]);
    }

    public static <R> BinaryOperator<R> mergeNotSupportedMerger() {
        return (m1, m2) -> {
            throw new IllegalStateException("Parallel processing is not supported");
        };
    }
}

