/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.component;

import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.utils.MessageException;
import org.sonar.ce.task.projectanalysis.analysis.MutableAnalysisMetadataHolder;
import org.sonar.ce.task.projectanalysis.component.BranchLoaderDelegate;
import org.sonar.ce.task.projectanalysis.component.DefaultBranchImpl;
import org.sonar.scanner.protocol.output.ScannerReport;

public class BranchLoader {
    private final MutableAnalysisMetadataHolder metadataHolder;
    private final BranchLoaderDelegate delegate;

    public BranchLoader(MutableAnalysisMetadataHolder metadataHolder) {
        this(metadataHolder, null);
    }

    public BranchLoader(MutableAnalysisMetadataHolder metadataHolder, @Nullable BranchLoaderDelegate delegate) {
        this.metadataHolder = metadataHolder;
        this.delegate = delegate;
    }

    public void load(ScannerReport.Metadata metadata) {
        String deprecatedBranch = StringUtils.trimToNull((String)metadata.getDeprecatedBranch());
        String branchName = StringUtils.trimToNull((String)metadata.getBranchName());
        if (deprecatedBranch != null && branchName != null) {
            throw MessageException.of((String)"Properties sonar.branch and sonar.branch.name can't be set together");
        }
        if (this.delegate == null && BranchLoader.hasBranchProperties(metadata)) {
            throw MessageException.of((String)"Current edition does not support branch feature");
        }
        if (this.delegate != null && deprecatedBranch == null) {
            this.delegate.load(metadata);
        } else {
            this.metadataHolder.setBranch(new DefaultBranchImpl(deprecatedBranch));
        }
    }

    private static boolean hasBranchProperties(ScannerReport.Metadata metadata) {
        return !metadata.getBranchName().isEmpty() || !metadata.getPullRequestKey().isEmpty() || !metadata.getMergeBranchName().isEmpty() || metadata.getBranchType() != ScannerReport.Metadata.BranchType.UNSET;
    }
}

