/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.sonar.ce.task.projectanalysis.component.ComponentUuidFactory;
import org.sonar.core.util.Uuids;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;

public class ComponentUuidFactoryImpl
implements ComponentUuidFactory {
    private final Map<String, String> uuidsByKey = new HashMap<String, String>();

    public ComponentUuidFactoryImpl(DbClient dbClient, DbSession dbSession, String rootKey) {
        List keys = dbClient.componentDao().selectUuidsByKeyFromProjectKey(dbSession, rootKey);
        keys.forEach(dto -> this.uuidsByKey.put(dto.key(), dto.uuid()));
    }

    @Override
    public String getOrCreateForKey(String key) {
        return this.uuidsByKey.computeIfAbsent(key, k -> Uuids.create());
    }
}

