/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.component;

import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.utils.MessageException;
import org.sonar.ce.task.projectanalysis.analysis.Branch;
import org.sonar.core.component.ComponentKeys;
import org.sonar.db.component.BranchType;

public class DefaultBranchImpl
implements Branch {
    private final String branchName;
    private final boolean isLegacyBranch;

    public DefaultBranchImpl() {
        this(null);
    }

    public DefaultBranchImpl(@Nullable String name) {
        this.isLegacyBranch = name != null;
        String string = this.branchName = name == null ? "master" : name;
        if (!ComponentKeys.isValidLegacyBranch((String)this.branchName)) {
            throw MessageException.of((String)String.format("\"%s\" is not a valid branch name. Allowed characters are alphanumeric, '-', '_', '.' and '/'.", this.branchName));
        }
    }

    @Override
    public BranchType getType() {
        return BranchType.LONG;
    }

    @Override
    public boolean isMain() {
        return true;
    }

    @Override
    public Optional<String> getMergeBranchUuid() {
        return Optional.empty();
    }

    @Override
    public boolean isLegacyFeature() {
        return this.isLegacyBranch;
    }

    @Override
    public String getName() {
        return this.branchName;
    }

    @Override
    public boolean supportsCrossProjectCpd() {
        return !this.isLegacyBranch;
    }

    @Override
    public String getPullRequestKey() {
        throw new IllegalStateException("Only a branch of type PULL_REQUEST can have a pull request id.");
    }

    @Override
    public String generateKey(String projectKey, @Nullable String fileOrDirPath) {
        if (this.isLegacyBranch) {
            projectKey = ComponentKeys.createKey((String)projectKey, (String)this.branchName);
        }
        if (StringUtils.isEmpty((String)fileOrDirPath)) {
            return projectKey;
        }
        return ComponentKeys.createEffectiveKey((String)projectKey, (String)StringUtils.trimToNull((String)fileOrDirPath));
    }
}

