/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.component;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckForNull;
import org.sonar.ce.task.projectanalysis.component.Component;
import org.sonar.ce.task.projectanalysis.component.ComponentVisitor;
import org.sonar.ce.task.projectanalysis.component.CrawlerDepthLimit;
import org.sonar.ce.task.projectanalysis.component.DepthTraversalTypeAwareCrawler;
import org.sonar.ce.task.projectanalysis.component.MutableTreeRootHolder;
import org.sonar.ce.task.projectanalysis.component.TypeAwareVisitorAdapter;

public class TreeRootHolderImpl
implements MutableTreeRootHolder {
    @CheckForNull
    private Map<Integer, Component> componentsByRef;
    @CheckForNull
    private Map<Integer, Component> extendedComponentsByRef;
    private int size;
    private Component root;
    private Component extendedTreeRoot;

    @Override
    public boolean isEmpty() {
        return this.root == null;
    }

    @Override
    public MutableTreeRootHolder setRoots(Component root, Component reportRoot) {
        Preconditions.checkState((this.root == null ? 1 : 0) != 0, (Object)"root can not be set twice in holder");
        this.root = Objects.requireNonNull(root, "root can not be null");
        this.extendedTreeRoot = Objects.requireNonNull(reportRoot, "extended tree root can not be null");
        return this;
    }

    @Override
    public Component getRoot() {
        this.checkInitialized();
        return this.root;
    }

    @Override
    public Component getReportTreeRoot() {
        this.checkInitialized();
        return this.extendedTreeRoot;
    }

    @Override
    public Component getComponentByRef(int ref) {
        return this.getOptionalComponentByRef(ref).orElseThrow(() -> new IllegalArgumentException(String.format("Component with ref '%s' can't be found", ref)));
    }

    @Override
    public Optional<Component> getOptionalComponentByRef(int ref) {
        this.checkInitialized();
        this.ensureComponentByRefIsPopulated();
        return Optional.ofNullable(this.componentsByRef.get(ref));
    }

    @Override
    public Component getReportTreeComponentByRef(int ref) {
        this.checkInitialized();
        this.ensureExtendedComponentByRefIsPopulated();
        Component c = this.extendedComponentsByRef.get(ref);
        if (c == null) {
            throw new IllegalArgumentException(String.format("Component with ref '%s' can't be found", ref));
        }
        return c;
    }

    @Override
    public int getSize() {
        this.checkInitialized();
        this.ensureComponentByRefIsPopulated();
        return this.size;
    }

    private void ensureExtendedComponentByRefIsPopulated() {
        if (this.extendedComponentsByRef != null) {
            return;
        }
        final ImmutableMap.Builder builder = ImmutableMap.builder();
        new DepthTraversalTypeAwareCrawler(new TypeAwareVisitorAdapter(CrawlerDepthLimit.FILE, ComponentVisitor.Order.POST_ORDER){

            @Override
            public void visitAny(Component component) {
                if (component.getReportAttributes().getRef() != null) {
                    builder.put((Object)component.getReportAttributes().getRef(), (Object)component);
                }
            }
        }).visit(this.extendedTreeRoot);
        this.extendedComponentsByRef = builder.build();
    }

    private void ensureComponentByRefIsPopulated() {
        if (this.componentsByRef != null) {
            return;
        }
        final ImmutableMap.Builder builder = ImmutableMap.builder();
        new DepthTraversalTypeAwareCrawler(new TypeAwareVisitorAdapter(CrawlerDepthLimit.FILE, ComponentVisitor.Order.POST_ORDER){

            @Override
            public void visitAny(Component component) {
                TreeRootHolderImpl.this.size++;
                if (component.getReportAttributes().getRef() != null) {
                    builder.put((Object)component.getReportAttributes().getRef(), (Object)component);
                }
            }
        }).visit(this.root);
        this.componentsByRef = builder.build();
    }

    private void checkInitialized() {
        Preconditions.checkState((this.root != null ? 1 : 0) != 0, (Object)"Holder has not been initialized yet");
    }
}

