/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.duplication;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.sonar.api.config.Configuration;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.ce.task.projectanalysis.component.Component;
import org.sonar.ce.task.projectanalysis.duplication.CrossProjectDuplicate;
import org.sonar.ce.task.projectanalysis.duplication.Duplicate;
import org.sonar.ce.task.projectanalysis.duplication.Duplication;
import org.sonar.ce.task.projectanalysis.duplication.DuplicationRepository;
import org.sonar.ce.task.projectanalysis.duplication.TextBlock;
import org.sonar.duplications.block.Block;
import org.sonar.duplications.detector.suffixtree.SuffixTreeCloneDetectionAlgorithm;
import org.sonar.duplications.index.CloneGroup;
import org.sonar.duplications.index.CloneIndex;
import org.sonar.duplications.index.ClonePart;
import org.sonar.duplications.index.PackedMemoryCloneIndex;

public class IntegrateCrossProjectDuplications {
    private static final Logger LOGGER = Loggers.get(IntegrateCrossProjectDuplications.class);
    private static final String JAVA_KEY = "java";
    private static final int MAX_CLONE_GROUP_PER_FILE = 100;
    private static final int MAX_CLONE_PART_PER_GROUP = 100;
    private final Configuration config;
    private final DuplicationRepository duplicationRepository;
    private Map<String, NumberOfUnitsNotLessThan> numberOfUnitsByLanguage = new HashMap<String, NumberOfUnitsNotLessThan>();

    public IntegrateCrossProjectDuplications(Configuration config, DuplicationRepository duplicationRepository) {
        this.config = config;
        this.duplicationRepository = duplicationRepository;
        if (config.getBoolean("sonar.cpd.cross_project").orElse(false).booleanValue()) {
            LOGGER.warn("This analysis uses the deprecated cross-project duplication feature.");
        }
    }

    public void computeCpd(Component component, Collection<Block> originBlocks, Collection<Block> duplicationBlocks) {
        PackedMemoryCloneIndex duplicationIndex = new PackedMemoryCloneIndex();
        IntegrateCrossProjectDuplications.populateIndex((CloneIndex)duplicationIndex, originBlocks);
        IntegrateCrossProjectDuplications.populateIndex((CloneIndex)duplicationIndex, duplicationBlocks);
        List duplications = SuffixTreeCloneDetectionAlgorithm.detect((CloneIndex)duplicationIndex, originBlocks);
        FluentIterable filtered = FluentIterable.from((Iterable)duplications).filter((Predicate)this.getNumberOfUnitsNotLessThan(component.getFileAttributes().getLanguageKey()));
        this.addDuplications(component, (Iterable<CloneGroup>)filtered);
    }

    private static void populateIndex(CloneIndex duplicationIndex, Collection<Block> duplicationBlocks) {
        for (Block block : duplicationBlocks) {
            duplicationIndex.insert(block);
        }
    }

    private void addDuplications(Component file, Iterable<CloneGroup> duplications) {
        int cloneGroupCount = 0;
        for (CloneGroup duplication : duplications) {
            if (++cloneGroupCount > 100) {
                LOGGER.warn("Too many duplication groups on file {}. Keeping only the first {} groups.", (Object)file.getDbKey(), (Object)100);
                break;
            }
            this.addDuplication(file, duplication);
        }
    }

    private void addDuplication(Component file, CloneGroup duplication) {
        ClonePart originPart = duplication.getOriginPart();
        Iterable<Duplicate> duplicates = IntegrateCrossProjectDuplications.convertClonePartsToDuplicates(file, duplication);
        if (!Iterables.isEmpty(duplicates)) {
            this.duplicationRepository.add(file, new Duplication(new TextBlock(originPart.getStartLine(), originPart.getEndLine()), duplicates));
        }
    }

    private static Iterable<Duplicate> convertClonePartsToDuplicates(Component file, CloneGroup duplication) {
        ClonePart originPart = duplication.getOriginPart();
        return FluentIterable.from((Iterable)duplication.getCloneParts()).filter((Predicate)new DoesNotMatchSameComponentKey(originPart.getResourceId())).filter((Predicate)new DuplicateLimiter(file, originPart)).transform((Function)ClonePartToCrossProjectDuplicate.INSTANCE);
    }

    private NumberOfUnitsNotLessThan getNumberOfUnitsNotLessThan(String language) {
        NumberOfUnitsNotLessThan numberOfUnitsNotLessThan = this.numberOfUnitsByLanguage.get(language);
        if (numberOfUnitsNotLessThan == null) {
            numberOfUnitsNotLessThan = new NumberOfUnitsNotLessThan(this.getMinimumTokens(language));
            this.numberOfUnitsByLanguage.put(language, numberOfUnitsNotLessThan);
        }
        return numberOfUnitsNotLessThan;
    }

    private int getMinimumTokens(String languageKey) {
        if (languageKey.equalsIgnoreCase(JAVA_KEY)) {
            return 0;
        }
        return this.config.getInt("sonar.cpd." + languageKey + ".minimumTokens").orElse(100);
    }

    private static enum ClonePartToCrossProjectDuplicate implements Function<ClonePart, Duplicate>
    {
        INSTANCE;


        @Nonnull
        public Duplicate apply(@Nonnull ClonePart input) {
            return new CrossProjectDuplicate(input.getResourceId(), new TextBlock(input.getStartLine(), input.getEndLine()));
        }
    }

    private static class DuplicateLimiter
    implements Predicate<ClonePart> {
        private final Component file;
        private final ClonePart originPart;
        private int counter = 0;

        public DuplicateLimiter(Component file, ClonePart originPart) {
            this.file = file;
            this.originPart = originPart;
        }

        public boolean apply(@Nonnull ClonePart input) {
            if (this.counter == 100) {
                LOGGER.warn("Too many duplication references on file {} for block at line {}. Keeping only the first {} references.", new Object[]{this.file.getDbKey(), this.originPart.getStartLine(), 100});
            }
            boolean res = this.counter <= 100;
            ++this.counter;
            return res;
        }
    }

    private static class DoesNotMatchSameComponentKey
    implements Predicate<ClonePart> {
        private final String componentKey;

        private DoesNotMatchSameComponentKey(String componentKey) {
            this.componentKey = componentKey;
        }

        public boolean apply(@Nonnull ClonePart part) {
            return !part.getResourceId().equals(this.componentKey);
        }
    }

    private static class NumberOfUnitsNotLessThan
    implements Predicate<CloneGroup> {
        private final int min;

        public NumberOfUnitsNotLessThan(int min) {
            this.min = min;
        }

        public boolean apply(@Nonnull CloneGroup input) {
            return input.getLengthInUnits() >= this.min;
        }
    }
}

