/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.filemove;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.apache.ibatis.session.ResultContext;
import org.apache.ibatis.session.ResultHandler;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.ce.task.projectanalysis.analysis.AnalysisMetadataHolder;
import org.sonar.ce.task.projectanalysis.component.Component;
import org.sonar.ce.task.projectanalysis.component.ComponentVisitor;
import org.sonar.ce.task.projectanalysis.component.CrawlerDepthLimit;
import org.sonar.ce.task.projectanalysis.component.DepthTraversalTypeAwareCrawler;
import org.sonar.ce.task.projectanalysis.component.TreeRootHolder;
import org.sonar.ce.task.projectanalysis.component.TypeAwareVisitorAdapter;
import org.sonar.ce.task.projectanalysis.filemove.FileSimilarity;
import org.sonar.ce.task.projectanalysis.filemove.Match;
import org.sonar.ce.task.projectanalysis.filemove.MatchesByScore;
import org.sonar.ce.task.projectanalysis.filemove.MovedFilesRepository;
import org.sonar.ce.task.projectanalysis.filemove.MutableAddedFileRepository;
import org.sonar.ce.task.projectanalysis.filemove.MutableMovedFilesRepository;
import org.sonar.ce.task.projectanalysis.filemove.ScoreMatrix;
import org.sonar.ce.task.projectanalysis.filemove.ScoreMatrixDumper;
import org.sonar.ce.task.projectanalysis.source.SourceLinesHashRepository;
import org.sonar.ce.task.step.ComputationStep;
import org.sonar.core.util.logs.Profiler;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.FileMoveRowDto;
import org.sonar.db.source.LineHashesWithUuidDto;

public class FileMoveDetectionStep
implements ComputationStep {
    static final int MIN_REQUIRED_SCORE = 85;
    private static final Logger LOG = Loggers.get(FileMoveDetectionStep.class);
    private static final Comparator<ScoreMatrix.ScoreFile> SCORE_FILE_COMPARATOR = (o1, o2) -> -1 * Integer.compare(o1.getLineCount(), o2.getLineCount());
    private static final double LOWER_BOUND_RATIO = 0.84;
    private static final double UPPER_BOUND_RATIO = 1.18;
    private final AnalysisMetadataHolder analysisMetadataHolder;
    private final TreeRootHolder rootHolder;
    private final DbClient dbClient;
    private final FileSimilarity fileSimilarity;
    private final MutableMovedFilesRepository movedFilesRepository;
    private final SourceLinesHashRepository sourceLinesHash;
    private final ScoreMatrixDumper scoreMatrixDumper;
    private final MutableAddedFileRepository addedFileRepository;

    public FileMoveDetectionStep(AnalysisMetadataHolder analysisMetadataHolder, TreeRootHolder rootHolder, DbClient dbClient, FileSimilarity fileSimilarity, MutableMovedFilesRepository movedFilesRepository, SourceLinesHashRepository sourceLinesHash, ScoreMatrixDumper scoreMatrixDumper, MutableAddedFileRepository addedFileRepository) {
        this.analysisMetadataHolder = analysisMetadataHolder;
        this.rootHolder = rootHolder;
        this.dbClient = dbClient;
        this.fileSimilarity = fileSimilarity;
        this.movedFilesRepository = movedFilesRepository;
        this.sourceLinesHash = sourceLinesHash;
        this.scoreMatrixDumper = scoreMatrixDumper;
        this.addedFileRepository = addedFileRepository;
    }

    public String getDescription() {
        return "Detect file moves";
    }

    public void execute(ComputationStep.Context context) {
        if (this.analysisMetadataHolder.isFirstAnalysis()) {
            LOG.debug("First analysis. Do nothing.");
            return;
        }
        Profiler p = Profiler.createIfTrace((Logger)LOG);
        p.start();
        Map<String, Component> reportFilesByUuid = FileMoveDetectionStep.getReportFilesByUuid(this.rootHolder.getRoot());
        context.getStatistics().add("reportFiles", (Object)reportFilesByUuid.size());
        if (reportFilesByUuid.isEmpty()) {
            LOG.debug("No files in report. No file move detection.");
            return;
        }
        Map<String, DbComponent> dbFilesByUuid = this.getDbFilesByUuid();
        context.getStatistics().add("dbFiles", (Object)dbFilesByUuid.size());
        Set<String> addedFileUuids = this.difference(reportFilesByUuid.keySet(), dbFilesByUuid.keySet());
        context.getStatistics().add("addedFiles", (Object)addedFileUuids.size());
        if (dbFilesByUuid.isEmpty()) {
            this.registerAddedFiles(addedFileUuids, reportFilesByUuid, null);
            LOG.debug("Previous snapshot has no file. No file move detection.");
            return;
        }
        Set<String> removedFileUuids = this.difference(dbFilesByUuid.keySet(), reportFilesByUuid.keySet());
        if (addedFileUuids.isEmpty() || removedFileUuids.isEmpty()) {
            this.registerAddedFiles(addedFileUuids, reportFilesByUuid, null);
            LOG.debug("Either no files added or no files removed. Do nothing.");
            return;
        }
        Map<String, FileSimilarity.File> reportFileSourcesByUuid = this.getReportFileSourcesByUuid(reportFilesByUuid, addedFileUuids);
        p.stopTrace("loaded");
        p.start();
        ScoreMatrix scoreMatrix = this.computeScoreMatrix(dbFilesByUuid, removedFileUuids, reportFileSourcesByUuid);
        p.stopTrace("Score matrix computed");
        this.scoreMatrixDumper.dumpAsCsv(scoreMatrix);
        if (scoreMatrix.getMaxScore() < 85) {
            context.getStatistics().add("movedFiles", (Object)0);
            this.registerAddedFiles(addedFileUuids, reportFilesByUuid, null);
            LOG.debug("max score in matrix is less than min required score ({}). Do nothing.", (Object)85);
            return;
        }
        p.start();
        MatchesByScore matchesByScore = MatchesByScore.create(scoreMatrix);
        ElectedMatches electedMatches = FileMoveDetectionStep.electMatches(removedFileUuids, reportFileSourcesByUuid, matchesByScore);
        p.stopTrace("Matches elected");
        context.getStatistics().add("movedFiles", (Object)electedMatches.size());
        this.registerMatches(dbFilesByUuid, reportFilesByUuid, electedMatches);
        this.registerAddedFiles(addedFileUuids, reportFilesByUuid, electedMatches);
    }

    public Set<String> difference(Set<String> set1, Set<String> set2) {
        if (set1.isEmpty() || set2.isEmpty()) {
            return set1;
        }
        return Sets.difference(set1, set2).immutableCopy();
    }

    private void registerMatches(Map<String, DbComponent> dbFilesByUuid, Map<String, Component> reportFilesByUuid, ElectedMatches electedMatches) {
        LOG.debug("{} files moves found", (Object)electedMatches.size());
        for (Match validatedMatch : electedMatches) {
            this.movedFilesRepository.setOriginalFile(reportFilesByUuid.get(validatedMatch.getReportUuid()), FileMoveDetectionStep.toOriginalFile(dbFilesByUuid.get(validatedMatch.getDbUuid())));
            LOG.trace("File move found: {}", (Object)validatedMatch);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void registerAddedFiles(Set<String> addedFileUuids, Map<String, Component> reportFilesByUuid, @Nullable ElectedMatches electedMatches) {
        block6: {
            block5: {
                if (electedMatches == null) break block5;
                if (!electedMatches.isEmpty()) break block6;
            }
            addedFileUuids.stream().map(reportFilesByUuid::get).forEach(this.addedFileRepository::register);
            return;
        }
        HashSet<String> reallyAddedFileUuids = new HashSet<String>(addedFileUuids);
        Iterator<Match> iterator = electedMatches.iterator();
        while (true) {
            if (!iterator.hasNext()) {
                reallyAddedFileUuids.stream().map(reportFilesByUuid::get).forEach(this.addedFileRepository::register);
                return;
            }
            Match electedMatch = iterator.next();
            reallyAddedFileUuids.remove(electedMatch.getReportUuid());
        }
    }

    private Map<String, DbComponent> getDbFilesByUuid() {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            ImmutableList.Builder builder = ImmutableList.builder();
            this.dbClient.componentDao().scrollAllFilesForFileMove(dbSession, this.rootHolder.getRoot().getUuid(), resultContext -> {
                FileMoveRowDto row = (FileMoveRowDto)resultContext.getResultObject();
                builder.add((Object)new DbComponent(row.getId(), row.getKey(), row.getUuid(), row.getPath(), row.getLineCount()));
            });
            Map map = (Map)builder.build().stream().collect(MoreCollectors.uniqueIndex(DbComponent::getUuid));
            return map;
        }
    }

    private static Map<String, Component> getReportFilesByUuid(Component root) {
        final ImmutableMap.Builder builder = ImmutableMap.builder();
        new DepthTraversalTypeAwareCrawler(new TypeAwareVisitorAdapter(CrawlerDepthLimit.FILE, ComponentVisitor.Order.POST_ORDER){

            @Override
            public void visitFile(Component file) {
                builder.put((Object)file.getUuid(), (Object)file);
            }
        }).visit(root);
        return builder.build();
    }

    private Map<String, FileSimilarity.File> getReportFileSourcesByUuid(Map<String, Component> reportFilesByUuid, Set<String> addedFileUuids) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (String fileUuid : addedFileUuids) {
            Component component = reportFilesByUuid.get(fileUuid);
            FileSimilarity.LazyFileImpl file = new FileSimilarity.LazyFileImpl(component.getName(), () -> this.getReportFileLineHashes(component), component.getFileAttributes().getLines());
            builder.put((Object)fileUuid, (Object)file);
        }
        return builder.build();
    }

    private List<String> getReportFileLineHashes(Component component) {
        return this.sourceLinesHash.getLineHashesMatchingDBVersion(component);
    }

    private ScoreMatrix computeScoreMatrix(Map<String, DbComponent> dtosByUuid, Set<String> removedFileUuids, Map<String, FileSimilarity.File> newFileSourcesByUuid) {
        ScoreMatrix.ScoreFile[] newFiles = (ScoreMatrix.ScoreFile[])newFileSourcesByUuid.entrySet().stream().map(e -> new ScoreMatrix.ScoreFile((String)e.getKey(), ((FileSimilarity.File)e.getValue()).getLineCount())).toArray(ScoreMatrix.ScoreFile[]::new);
        ScoreMatrix.ScoreFile[] removedFiles = (ScoreMatrix.ScoreFile[])removedFileUuids.stream().map(key -> {
            DbComponent dbComponent = (DbComponent)dtosByUuid.get(key);
            return new ScoreMatrix.ScoreFile(dbComponent.getUuid(), dbComponent.getLineCount());
        }).toArray(ScoreMatrix.ScoreFile[]::new);
        Arrays.sort(newFiles, SCORE_FILE_COMPARATOR);
        Arrays.sort(removedFiles, SCORE_FILE_COMPARATOR);
        int[][] scoreMatrix = new int[removedFiles.length][newFiles.length];
        int lastNewFileIndex = newFiles.length - 1;
        HashMap<String, Integer> removedFilesIndexes = new HashMap<String, Integer>(removedFileUuids.size());
        for (int removeFileIndex = 0; removeFileIndex < removedFiles.length; ++removeFileIndex) {
            ScoreMatrix.ScoreFile removedFile = removedFiles[removeFileIndex];
            int lowerBound = (int)Math.floor((double)removedFile.getLineCount() * 0.84);
            int upperBound = (int)Math.ceil((double)removedFile.getLineCount() * 1.18);
            if (newFiles[0].getLineCount() <= lowerBound || newFiles[lastNewFileIndex].getLineCount() >= upperBound) continue;
            removedFilesIndexes.put(removedFile.getFileUuid(), removeFileIndex);
        }
        LineHashesWithKeyDtoResultHandler rowHandler = new LineHashesWithKeyDtoResultHandler(removedFilesIndexes, removedFiles, newFiles, newFileSourcesByUuid, scoreMatrix);
        try (DbSession dbSession = this.dbClient.openSession(false);){
            this.dbClient.fileSourceDao().scrollLineHashes(dbSession, removedFilesIndexes.keySet(), (ResultHandler)rowHandler);
        }
        return new ScoreMatrix(removedFiles, newFiles, scoreMatrix, rowHandler.getMaxScore());
    }

    private static ElectedMatches electMatches(Set<String> dbFileUuids, Map<String, FileSimilarity.File> reportFileSourcesByUuid, MatchesByScore matchesByScore) {
        ElectedMatches electedMatches = new ElectedMatches(matchesByScore, dbFileUuids, reportFileSourcesByUuid);
        ArrayListMultimap matchesPerFileForScore = ArrayListMultimap.create();
        matchesByScore.forEach(arg_0 -> FileMoveDetectionStep.lambda$electMatches$7(electedMatches, (Multimap)matchesPerFileForScore, arg_0));
        return electedMatches;
    }

    private static void electMatches(@Nullable List<Match> matches, ElectedMatches electedMatches, Multimap<String, Match> matchesPerFileForScore) {
        if (matches == null) {
            return;
        }
        List<Match> matchesToValidate = electedMatches.filter(matches);
        if (matchesToValidate.isEmpty()) {
            return;
        }
        if (matchesToValidate.size() == 1) {
            Match match = matchesToValidate.get(0);
            electedMatches.add(match);
        } else {
            matchesPerFileForScore.clear();
            for (Match match : matchesToValidate) {
                matchesPerFileForScore.put((Object)match.getDbUuid(), (Object)match);
                matchesPerFileForScore.put((Object)match.getReportUuid(), (Object)match);
            }
            for (Match match : matchesToValidate) {
                int dbFileMatchesCount = matchesPerFileForScore.get((Object)match.getDbUuid()).size();
                int reportFileMatchesCount = matchesPerFileForScore.get((Object)match.getReportUuid()).size();
                if (dbFileMatchesCount != 1 || reportFileMatchesCount != 1) continue;
                electedMatches.add(match);
            }
        }
    }

    private static MovedFilesRepository.OriginalFile toOriginalFile(DbComponent dbComponent) {
        return new MovedFilesRepository.OriginalFile(dbComponent.getId(), dbComponent.getUuid(), dbComponent.getKey());
    }

    private static /* synthetic */ void lambda$electMatches$7(ElectedMatches electedMatches, Multimap matchesPerFileForScore, List matches) {
        FileMoveDetectionStep.electMatches(matches, electedMatches, (Multimap<String, Match>)matchesPerFileForScore);
    }

    private static class ElectedMatches
    implements Iterable<Match> {
        private final List<Match> matches;
        private final Set<String> matchedFileUuids;

        public ElectedMatches(MatchesByScore matchesByScore, Set<String> dbFileUuids, Map<String, FileSimilarity.File> reportFileSourcesByUuid) {
            this.matches = new ArrayList<Match>(matchesByScore.getSize());
            this.matchedFileUuids = new HashSet<String>(dbFileUuids.size() + reportFileSourcesByUuid.size());
        }

        public void add(Match match) {
            this.matches.add(match);
            this.matchedFileUuids.add(match.getDbUuid());
            this.matchedFileUuids.add(match.getReportUuid());
        }

        public List<Match> filter(Iterable<Match> matches) {
            return FluentIterable.from(matches).filter(this::notAlreadyMatched).toList();
        }

        private boolean notAlreadyMatched(Match input) {
            return !this.matchedFileUuids.contains(input.getDbUuid()) && !this.matchedFileUuids.contains(input.getReportUuid());
        }

        @Override
        public Iterator<Match> iterator() {
            return this.matches.iterator();
        }

        public int size() {
            return this.matches.size();
        }

        public boolean isEmpty() {
            return this.matches.isEmpty();
        }
    }

    @Immutable
    private static final class DbComponent {
        private final long id;
        private final String key;
        private final String uuid;
        private final String path;
        private final int lineCount;

        private DbComponent(long id, String key, String uuid, String path, int lineCount) {
            this.id = id;
            this.key = key;
            this.uuid = uuid;
            this.path = path;
            this.lineCount = lineCount;
        }

        public long getId() {
            return this.id;
        }

        public String getKey() {
            return this.key;
        }

        public String getUuid() {
            return this.uuid;
        }

        public String getPath() {
            return this.path;
        }

        public int getLineCount() {
            return this.lineCount;
        }
    }

    private final class LineHashesWithKeyDtoResultHandler
    implements ResultHandler<LineHashesWithUuidDto> {
        private final Map<String, Integer> removedFilesIndexes;
        private final ScoreMatrix.ScoreFile[] removedFiles;
        private final ScoreMatrix.ScoreFile[] newFiles;
        private final Map<String, FileSimilarity.File> newFileSourcesByKey;
        private final int[][] scoreMatrix;
        private int maxScore;

        private LineHashesWithKeyDtoResultHandler(Map<String, Integer> removedFilesIndexes, ScoreMatrix.ScoreFile[] removedFiles, ScoreMatrix.ScoreFile[] newFiles, Map<String, FileSimilarity.File> newFileSourcesByKey, int[][] scoreMatrix) {
            this.removedFilesIndexes = removedFilesIndexes;
            this.removedFiles = removedFiles;
            this.newFiles = newFiles;
            this.newFileSourcesByKey = newFileSourcesByKey;
            this.scoreMatrix = scoreMatrix;
        }

        public void handleResult(ResultContext<? extends LineHashesWithUuidDto> resultContext) {
            LineHashesWithUuidDto lineHashesDto = (LineHashesWithUuidDto)resultContext.getResultObject();
            if (lineHashesDto.getPath() == null) {
                return;
            }
            int removeFileIndex = this.removedFilesIndexes.get(lineHashesDto.getUuid());
            ScoreMatrix.ScoreFile removedFile = this.removedFiles[removeFileIndex];
            int lowerBound = (int)Math.floor((double)removedFile.getLineCount() * 0.84);
            int upperBound = (int)Math.ceil((double)removedFile.getLineCount() * 1.18);
            for (int newFileIndex = 0; newFileIndex < this.newFiles.length; ++newFileIndex) {
                int score;
                ScoreMatrix.ScoreFile newFile = this.newFiles[newFileIndex];
                if (newFile.getLineCount() >= upperBound) continue;
                if (newFile.getLineCount() <= lowerBound) break;
                FileSimilarity.FileImpl fileInDb = new FileSimilarity.FileImpl(lineHashesDto.getPath(), lineHashesDto.getLineHashes());
                FileSimilarity.File unmatchedFile = this.newFileSourcesByKey.get(newFile.getFileUuid());
                this.scoreMatrix[removeFileIndex][newFileIndex] = score = FileMoveDetectionStep.this.fileSimilarity.score(fileInDb, unmatchedFile);
                if (score <= this.maxScore) continue;
                this.maxScore = score;
            }
        }

        int getMaxScore() {
            return this.maxScore;
        }
    }
}

