/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.filemove;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;

public interface FileSimilarity {
    public int score(File var1, File var2);

    public static final class LazyFileImpl
    implements File {
        private final String path;
        private final Supplier<List<String>> supplier;
        private final int lineCount;
        private List<String> lineHashes;

        LazyFileImpl(String path, Supplier<List<String>> supplier, int lineCount) {
            this.path = Objects.requireNonNull(path, "path can not be null");
            this.supplier = Objects.requireNonNull(supplier, "supplier can not be null");
            this.lineCount = lineCount;
        }

        @Override
        public String getPath() {
            return this.path;
        }

        @Override
        public List<String> getLineHashes() {
            this.ensureSupplierCalled();
            return this.lineHashes;
        }

        private void ensureSupplierCalled() {
            if (this.lineHashes == null) {
                this.lineHashes = Optional.ofNullable(this.supplier.get()).orElse(Collections.emptyList());
            }
        }

        @Override
        public int getLineCount() {
            return this.lineCount;
        }
    }

    public static final class FileImpl
    implements File {
        private final String path;
        private final List<String> lineHashes;
        private final int lineCount;

        FileImpl(String path, List<String> lineHashes) {
            this.path = Objects.requireNonNull(path, "path can not be null");
            this.lineHashes = Objects.requireNonNull(lineHashes, "lineHashes can not be null");
            this.lineCount = lineHashes.size();
        }

        @Override
        public String getPath() {
            return this.path;
        }

        @Override
        public List<String> getLineHashes() {
            return this.lineHashes;
        }

        @Override
        public int getLineCount() {
            return this.lineCount;
        }
    }

    public static interface File {
        public String getPath();

        public List<String> getLineHashes();

        public int getLineCount();
    }
}

