/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.formula;

import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckForNull;
import org.sonar.ce.task.projectanalysis.component.Component;
import org.sonar.ce.task.projectanalysis.component.ComponentVisitor;
import org.sonar.ce.task.projectanalysis.component.CrawlerDepthLimit;
import org.sonar.ce.task.projectanalysis.component.PathAwareVisitor;
import org.sonar.ce.task.projectanalysis.component.PathAwareVisitorAdapter;
import org.sonar.ce.task.projectanalysis.formula.Counter;
import org.sonar.ce.task.projectanalysis.formula.CounterInitializationContext;
import org.sonar.ce.task.projectanalysis.formula.CreateMeasureContext;
import org.sonar.ce.task.projectanalysis.formula.Formula;
import org.sonar.ce.task.projectanalysis.measure.Measure;
import org.sonar.ce.task.projectanalysis.measure.MeasureRepository;
import org.sonar.ce.task.projectanalysis.metric.Metric;
import org.sonar.ce.task.projectanalysis.metric.MetricRepository;

public class FormulaExecutorComponentVisitor
extends PathAwareVisitorAdapter<Counters> {
    private static final PathAwareVisitorAdapter.SimpleStackElementFactory<Counters> COUNTERS_FACTORY = new PathAwareVisitorAdapter.SimpleStackElementFactory<Counters>(){

        @Override
        public Counters createForAny(Component component) {
            return new Counters();
        }

        @Override
        public Counters createForFile(Component component) {
            return null;
        }

        @Override
        public Counters createForProjectView(Component projectView) {
            return null;
        }
    };
    private final MetricRepository metricRepository;
    private final MeasureRepository measureRepository;
    private final List<Formula> formulas;

    private FormulaExecutorComponentVisitor(Builder builder, Iterable<Formula> formulas) {
        super(CrawlerDepthLimit.LEAVES, ComponentVisitor.Order.POST_ORDER, COUNTERS_FACTORY);
        this.measureRepository = builder.measureRepository;
        this.metricRepository = builder.metricRepository;
        this.formulas = ImmutableList.copyOf(formulas);
    }

    public static Builder newBuilder(MetricRepository metricRepository, MeasureRepository measureRepository) {
        return new Builder(metricRepository, measureRepository);
    }

    @Override
    public void visitProject(Component project, PathAwareVisitor.Path<Counters> path) {
        this.process(project, path);
    }

    @Override
    public void visitDirectory(Component directory, PathAwareVisitor.Path<Counters> path) {
        this.process(directory, path);
    }

    @Override
    public void visitFile(Component file, PathAwareVisitor.Path<Counters> path) {
        this.process(file, path);
    }

    @Override
    public void visitView(Component view, PathAwareVisitor.Path<Counters> path) {
        this.process(view, path);
    }

    @Override
    public void visitSubView(Component subView, PathAwareVisitor.Path<Counters> path) {
        this.process(subView, path);
    }

    @Override
    public void visitProjectView(Component projectView, PathAwareVisitor.Path<Counters> path) {
        this.process(projectView, path);
    }

    private void process(Component component, PathAwareVisitor.Path<Counters> path) {
        if (component.getChildren().isEmpty()) {
            this.processLeaf(component, path);
        } else {
            this.processNotLeaf(component, path);
        }
    }

    private void processNotLeaf(Component component, PathAwareVisitor.Path<Counters> path) {
        for (Formula formula : this.formulas) {
            Counter counter = path.current().getCounter(formula);
            if (counter == null) continue;
            for (String metricKey : formula.getOutputMetricKeys()) {
                this.addNewMeasure(component, metricKey, formula, counter);
            }
            FormulaExecutorComponentVisitor.aggregateToParent(path, formula, counter);
        }
    }

    private void processLeaf(Component component, PathAwareVisitor.Path<Counters> path) {
        CounterInitializationContextImpl counterContext = new CounterInitializationContextImpl(component);
        for (Formula formula : this.formulas) {
            Object counter = formula.createNewCounter();
            counter.initialize(counterContext);
            for (String metricKey : formula.getOutputMetricKeys()) {
                this.addNewMeasure(component, metricKey, formula, (Counter)counter);
            }
            FormulaExecutorComponentVisitor.aggregateToParent(path, formula, counter);
        }
    }

    private void addNewMeasure(Component component, String metricKey, Formula formula, Counter counter) {
        if (component.getType() == Component.Type.PROJECT_VIEW) {
            return;
        }
        Metric metric = this.metricRepository.getByKey(metricKey);
        Optional<Measure> measure = formula.createMeasure(counter, new CreateMeasureContextImpl(component, metric));
        if (measure.isPresent()) {
            this.measureRepository.add(component, metric, measure.get());
        }
    }

    private static void aggregateToParent(PathAwareVisitor.Path<Counters> path, Formula formula, Counter currentCounter) {
        if (!path.isRoot()) {
            path.parent().aggregate(formula, currentCounter);
        }
    }

    private static class CreateMeasureContextImpl
    implements CreateMeasureContext {
        private final Component component;
        private final Metric metric;

        public CreateMeasureContextImpl(Component component, Metric metric) {
            this.component = component;
            this.metric = metric;
        }

        @Override
        public Component getComponent() {
            return this.component;
        }

        @Override
        public Metric getMetric() {
            return this.metric;
        }
    }

    public static class Counters {
        Map<Formula, Counter> countersByFormula = new HashMap<Formula, Counter>();

        public void aggregate(Formula formula, Counter childCounter) {
            Counter counter = this.countersByFormula.get(formula);
            if (counter == null) {
                this.countersByFormula.put(formula, childCounter);
            } else {
                counter.aggregate(childCounter);
            }
        }

        @CheckForNull
        public Counter getCounter(Formula formula) {
            return this.countersByFormula.get(formula);
        }
    }

    private class CounterInitializationContextImpl
    implements CounterInitializationContext {
        private final Component component;

        public CounterInitializationContextImpl(Component component) {
            this.component = component;
        }

        @Override
        public Component getLeaf() {
            return this.component;
        }

        @Override
        public Optional<Measure> getMeasure(String metricKey) {
            return FormulaExecutorComponentVisitor.this.measureRepository.getRawMeasure(this.component, FormulaExecutorComponentVisitor.this.metricRepository.getByKey(metricKey));
        }
    }

    public static class Builder {
        private final MetricRepository metricRepository;
        private final MeasureRepository measureRepository;

        private Builder(MetricRepository metricRepository, MeasureRepository measureRepository) {
            this.metricRepository = Objects.requireNonNull(metricRepository);
            this.measureRepository = Objects.requireNonNull(measureRepository);
        }

        public Builder create(MetricRepository metricRepository, MeasureRepository measureRepository) {
            return new Builder(metricRepository, measureRepository);
        }

        public FormulaExecutorComponentVisitor buildFor(Iterable<Formula> formulas) {
            return new FormulaExecutorComponentVisitor(this, formulas);
        }
    }
}

