/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.formula.coverage;

import java.util.Optional;
import org.sonar.ce.task.projectanalysis.formula.CreateMeasureContext;
import org.sonar.ce.task.projectanalysis.formula.Formula;
import org.sonar.ce.task.projectanalysis.formula.counter.LongValue;
import org.sonar.ce.task.projectanalysis.formula.coverage.CoverageUtils;
import org.sonar.ce.task.projectanalysis.formula.coverage.ElementsAndCoveredElementsVariationCounter;
import org.sonar.ce.task.projectanalysis.measure.Measure;

public abstract class CoverageVariationFormula<T extends ElementsAndCoveredElementsVariationCounter>
implements Formula<T> {
    @Override
    public Optional<Measure> createMeasure(T counter, CreateMeasureContext context) {
        LongValue elements = ((ElementsAndCoveredElementsVariationCounter)counter).elements;
        if (elements.isSet() && (double)elements.getValue() > 0.0) {
            LongValue coveredElements = ((ElementsAndCoveredElementsVariationCounter)counter).coveredElements;
            double variation = CoverageUtils.calculateCoverage(coveredElements.getValue(), elements.getValue());
            return Optional.of(Measure.newMeasureBuilder().setVariation(variation).createNoValue());
        }
        return Optional.empty();
    }
}

