/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.issue;

import java.util.Comparator;
import java.util.Date;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.ce.task.projectanalysis.analysis.AnalysisMetadataHolder;
import org.sonar.ce.task.projectanalysis.component.Component;
import org.sonar.ce.task.projectanalysis.issue.DefaultAssignee;
import org.sonar.ce.task.projectanalysis.issue.IssueLocations;
import org.sonar.ce.task.projectanalysis.issue.IssueVisitor;
import org.sonar.ce.task.projectanalysis.issue.ScmAccountToUser;
import org.sonar.ce.task.projectanalysis.scm.Changeset;
import org.sonar.ce.task.projectanalysis.scm.ScmInfo;
import org.sonar.ce.task.projectanalysis.scm.ScmInfoRepository;
import org.sonar.core.issue.DefaultIssue;
import org.sonar.core.issue.IssueChangeContext;
import org.sonar.server.issue.IssueFieldsSetter;

public class IssueAssigner
extends IssueVisitor {
    private static final Logger LOGGER = Loggers.get(IssueAssigner.class);
    private final ScmInfoRepository scmInfoRepository;
    private final DefaultAssignee defaultAssignee;
    private final IssueFieldsSetter issueUpdater;
    private final ScmAccountToUser scmAccountToUser;
    private final IssueChangeContext changeContext;
    private String lastCommitAuthor = null;
    private ScmInfo scmChangesets = null;

    public IssueAssigner(AnalysisMetadataHolder analysisMetadataHolder, ScmInfoRepository scmInfoRepository, ScmAccountToUser scmAccountToUser, DefaultAssignee defaultAssignee, IssueFieldsSetter issueUpdater) {
        this.scmInfoRepository = scmInfoRepository;
        this.scmAccountToUser = scmAccountToUser;
        this.defaultAssignee = defaultAssignee;
        this.issueUpdater = issueUpdater;
        this.changeContext = IssueChangeContext.createScan((Date)new Date(analysisMetadataHolder.getAnalysisDate()));
    }

    @Override
    public void onIssue(Component component, DefaultIssue issue) {
        if (issue.authorLogin() != null) {
            return;
        }
        this.loadScmChangesets(component);
        Optional<String> scmAuthor = this.guessScmAuthor(issue, component);
        if (scmAuthor.isPresent()) {
            if (scmAuthor.get().length() <= 255) {
                this.issueUpdater.setNewAuthor(issue, scmAuthor.get(), this.changeContext);
            } else {
                LOGGER.debug("SCM account '{}' is too long to be stored as issue author", (Object)scmAuthor.get());
            }
        }
        if (issue.assignee() == null) {
            String assigneeUuid = scmAuthor.map(this.scmAccountToUser::getNullable).orElse(null);
            assigneeUuid = StringUtils.defaultIfEmpty((String)assigneeUuid, (String)this.defaultAssignee.loadDefaultAssigneeUuid());
            this.issueUpdater.setNewAssignee(issue, assigneeUuid, this.changeContext);
        }
    }

    private void loadScmChangesets(Component component) {
        Optional<ScmInfo> scmInfoOptional;
        if (this.scmChangesets == null && (scmInfoOptional = this.scmInfoRepository.getScmInfo(component)).isPresent()) {
            this.scmChangesets = scmInfoOptional.get();
            this.lastCommitAuthor = this.scmChangesets.getLatestChangeset().getAuthor();
        }
    }

    @Override
    public void afterComponent(Component component) {
        this.lastCommitAuthor = null;
        this.scmChangesets = null;
    }

    private Optional<String> guessScmAuthor(DefaultIssue issue, Component component) {
        String author = null;
        if (this.scmChangesets != null) {
            author = IssueLocations.allLinesFor(issue, component.getUuid()).filter(this.scmChangesets::hasChangesetForLine).mapToObj(this.scmChangesets::getChangesetForLine).filter(c -> StringUtils.isNotEmpty((String)c.getAuthor())).max(Comparator.comparingLong(Changeset::getDate)).map(Changeset::getAuthor).orElse(null);
        }
        return Optional.ofNullable(StringUtils.defaultIfEmpty(author, (String)this.lastCommitAuthor));
    }
}

