/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.issue;

import com.google.common.base.Preconditions;
import java.util.Objects;
import javax.annotation.CheckForNull;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.rules.RuleType;
import org.sonar.scanner.protocol.Constants;
import org.sonar.scanner.protocol.output.ScannerReport;

@Immutable
public class NewAdHocRule {
    private final RuleKey key;
    private final String engineId;
    private final String ruleId;
    private final String name;
    private final String description;
    private final String severity;
    private final RuleType ruleType;
    private final boolean hasDetails;

    public NewAdHocRule(ScannerReport.AdHocRule ruleFromScannerReport) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)ruleFromScannerReport.getEngineId()), (Object)"'engine id' not expected to be null for an ad hoc rule");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)ruleFromScannerReport.getRuleId()), (Object)"'rule id' not expected to be null for an ad hoc rule");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)ruleFromScannerReport.getName()), (Object)"'name' not expected to be null for an ad hoc rule");
        Preconditions.checkArgument((ruleFromScannerReport.getSeverity() != Constants.Severity.UNSET_SEVERITY ? 1 : 0) != 0, (Object)"'severity' not expected to be null for an ad hoc rule");
        Preconditions.checkArgument((ruleFromScannerReport.getType() != ScannerReport.IssueType.UNSET ? 1 : 0) != 0, (Object)"'issue type' not expected to be null for an ad hoc rule");
        this.key = RuleKey.of((String)("external_" + ruleFromScannerReport.getEngineId()), (String)ruleFromScannerReport.getRuleId());
        this.engineId = ruleFromScannerReport.getEngineId();
        this.ruleId = ruleFromScannerReport.getRuleId();
        this.name = ruleFromScannerReport.getName();
        this.description = StringUtils.trimToNull((String)ruleFromScannerReport.getDescription());
        this.severity = ruleFromScannerReport.getSeverity().name();
        this.ruleType = RuleType.valueOf((String)ruleFromScannerReport.getType().name());
        this.hasDetails = true;
    }

    public NewAdHocRule(ScannerReport.ExternalIssue fromIssue) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)fromIssue.getEngineId()), (Object)"'engine id' not expected to be null for an ad hoc rule");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)fromIssue.getRuleId()), (Object)"'rule id' not expected to be null for an ad hoc rule");
        this.key = RuleKey.of((String)("external_" + fromIssue.getEngineId()), (String)fromIssue.getRuleId());
        this.engineId = fromIssue.getEngineId();
        this.ruleId = fromIssue.getRuleId();
        this.name = null;
        this.description = null;
        this.severity = null;
        this.ruleType = null;
        this.hasDetails = false;
    }

    public RuleKey getKey() {
        return this.key;
    }

    public String getEngineId() {
        return this.engineId;
    }

    public String getRuleId() {
        return this.ruleId;
    }

    @CheckForNull
    public String getName() {
        return this.name;
    }

    @CheckForNull
    public String getDescription() {
        return this.description;
    }

    @CheckForNull
    public String getSeverity() {
        return this.severity;
    }

    @CheckForNull
    public RuleType getRuleType() {
        return this.ruleType;
    }

    public boolean hasDetails() {
        return this.hasDetails;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NewAdHocRule that = (NewAdHocRule)o;
        return Objects.equals(this.key, that.key);
    }

    public int hashCode() {
        return this.key.hashCode();
    }
}

