/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.issue;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonar.api.utils.DateUtils;
import org.sonar.ce.task.projectanalysis.component.Component;
import org.sonar.ce.task.projectanalysis.component.ShortBranchComponentsWithIssues;
import org.sonar.ce.task.projectanalysis.issue.ComponentIssuesLoader;
import org.sonar.ce.task.projectanalysis.issue.ShortBranchIssue;
import org.sonar.core.issue.DefaultIssue;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.issue.IssueDto;
import org.sonar.db.issue.ShortBranchIssueDto;

public class ShortBranchIssuesLoader {
    private final ShortBranchComponentsWithIssues shortBranchComponentsWithIssues;
    private final DbClient dbClient;
    private final ComponentIssuesLoader componentIssuesLoader;

    public ShortBranchIssuesLoader(ShortBranchComponentsWithIssues shortBranchComponentsWithIssues, DbClient dbClient, ComponentIssuesLoader componentIssuesLoader) {
        this.shortBranchComponentsWithIssues = shortBranchComponentsWithIssues;
        this.dbClient = dbClient;
        this.componentIssuesLoader = componentIssuesLoader;
    }

    public Collection<ShortBranchIssue> loadCandidateIssuesForMergingInTargetBranch(Component component) {
        String componentKey = ComponentDto.removeBranchAndPullRequestFromKey((String)component.getDbKey());
        Set<String> uuids = this.shortBranchComponentsWithIssues.getUuids(componentKey);
        if (uuids.isEmpty()) {
            return Collections.emptyList();
        }
        try (DbSession session = this.dbClient.openSession(false);){
            Collection collection = this.dbClient.issueDao().selectOpenByComponentUuids(session, uuids).stream().map(ShortBranchIssuesLoader::toShortBranchIssue).collect(Collectors.toList());
            return collection;
        }
    }

    private static ShortBranchIssue toShortBranchIssue(ShortBranchIssueDto dto) {
        return new ShortBranchIssue(dto.getKey(), dto.getLine(), dto.getMessage(), dto.getChecksum(), dto.getRuleKey(), dto.getStatus(), dto.getBranchName(), DateUtils.longToDate((Long)dto.getIssueCreationDate()));
    }

    public Map<ShortBranchIssue, DefaultIssue> loadDefaultIssuesWithChanges(Collection<ShortBranchIssue> lightIssues) {
        if (lightIssues.isEmpty()) {
            return Collections.emptyMap();
        }
        Map<String, ShortBranchIssue> issuesByKey = lightIssues.stream().collect(Collectors.toMap(ShortBranchIssue::getKey, i -> i));
        try (DbSession session = this.dbClient.openSession(false);){
            List issues = (List)this.dbClient.issueDao().selectByKeys(session, issuesByKey.keySet()).stream().map(IssueDto::toDefaultIssue).collect(MoreCollectors.toList((int)issuesByKey.size()));
            this.componentIssuesLoader.loadChanges(session, issues);
            Map map = (Map)issues.stream().collect(MoreCollectors.uniqueIndex(i -> (ShortBranchIssue)issuesByKey.get(i.key()), i -> i, (int)issues.size()));
            return map;
        }
    }
}

