/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.issue;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonar.ce.task.projectanalysis.component.Component;
import org.sonar.ce.task.projectanalysis.issue.DefaultTrackingInput;
import org.sonar.ce.task.projectanalysis.issue.IssueLocations;
import org.sonar.ce.task.projectanalysis.issue.TrackerBaseInputFactory;
import org.sonar.ce.task.projectanalysis.issue.TrackerMergeBranchInputFactory;
import org.sonar.ce.task.projectanalysis.issue.TrackerRawInputFactory;
import org.sonar.ce.task.projectanalysis.source.NewLinesRepository;
import org.sonar.core.issue.DefaultIssue;
import org.sonar.core.issue.tracking.Input;
import org.sonar.core.issue.tracking.NonClosedTracking;
import org.sonar.core.issue.tracking.Tracker;
import org.sonar.core.issue.tracking.Tracking;
import org.sonar.core.util.stream.MoreCollectors;

public class ShortBranchOrPullRequestTrackerExecution {
    private final TrackerBaseInputFactory baseInputFactory;
    private final TrackerRawInputFactory rawInputFactory;
    private final TrackerMergeBranchInputFactory mergeInputFactory;
    private final Tracker<DefaultIssue, DefaultIssue> tracker;
    private final NewLinesRepository newLinesRepository;

    public ShortBranchOrPullRequestTrackerExecution(TrackerBaseInputFactory baseInputFactory, TrackerRawInputFactory rawInputFactory, TrackerMergeBranchInputFactory mergeInputFactory, Tracker<DefaultIssue, DefaultIssue> tracker, NewLinesRepository newLinesRepository) {
        this.baseInputFactory = baseInputFactory;
        this.rawInputFactory = rawInputFactory;
        this.mergeInputFactory = mergeInputFactory;
        this.tracker = tracker;
        this.newLinesRepository = newLinesRepository;
    }

    public Tracking<DefaultIssue, DefaultIssue> track(Component component) {
        DefaultTrackingInput unmatchedRawInput;
        Input<DefaultIssue> rawInput = this.rawInputFactory.create(component);
        Input<DefaultIssue> baseInput = this.baseInputFactory.create(component);
        if (this.mergeInputFactory.hasMergeBranchAnalysis()) {
            Input<DefaultIssue> mergeInput = this.mergeInputFactory.create(component);
            NonClosedTracking mergeTracking = this.tracker.trackNonClosed(rawInput, mergeInput);
            List unmatchedRaws = (List)mergeTracking.getUnmatchedRaws().collect(MoreCollectors.toList());
            unmatchedRawInput = new DefaultTrackingInput(unmatchedRaws, rawInput.getLineHashSequence(), rawInput.getBlockHashSequence());
        } else {
            List<DefaultIssue> filteredRaws = this.keepIssuesHavingAtLeastOneLocationOnChangedLines(component, rawInput.getIssues());
            unmatchedRawInput = new DefaultTrackingInput(filteredRaws, rawInput.getLineHashSequence(), rawInput.getBlockHashSequence());
        }
        return this.tracker.trackNonClosed((Input)unmatchedRawInput, baseInput);
    }

    private List<DefaultIssue> keepIssuesHavingAtLeastOneLocationOnChangedLines(Component component, Collection<DefaultIssue> issues) {
        if (component.getType() != Component.Type.FILE) {
            return Collections.emptyList();
        }
        Optional<Set<Integer>> newLinesOpt = this.newLinesRepository.getNewLines(component);
        if (!newLinesOpt.isPresent()) {
            return Collections.emptyList();
        }
        Set<Integer> newLines = newLinesOpt.get();
        return issues.stream().filter(i -> IssueLocations.allLinesFor(i, component.getUuid()).anyMatch(newLines::contains)).collect(Collectors.toList());
    }
}

