/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.issue.commonrule;

import java.util.Optional;
import org.sonar.ce.task.projectanalysis.component.Component;
import org.sonar.ce.task.projectanalysis.issue.commonrule.CommonRule;
import org.sonar.ce.task.projectanalysis.measure.Measure;
import org.sonar.ce.task.projectanalysis.measure.MeasureRepository;
import org.sonar.ce.task.projectanalysis.metric.Metric;
import org.sonar.ce.task.projectanalysis.metric.MetricRepository;
import org.sonar.ce.task.projectanalysis.qualityprofile.ActiveRule;
import org.sonar.ce.task.projectanalysis.qualityprofile.ActiveRulesHolder;

public class SkippedTestRule
extends CommonRule {
    private final MeasureRepository measureRepository;
    private final Metric skippedTestsMetric;

    public SkippedTestRule(ActiveRulesHolder activeRulesHolder, MeasureRepository measureRepository, MetricRepository metricRepository) {
        super(activeRulesHolder, "SkippedUnitTests");
        this.measureRepository = measureRepository;
        this.skippedTestsMetric = metricRepository.getByKey("skipped_tests");
    }

    @Override
    protected CommonRule.CommonRuleIssue doProcessFile(Component file, ActiveRule activeRule) {
        Optional<Measure> measure = this.measureRepository.getRawMeasure(file, this.skippedTestsMetric);
        int skipped = measure.map(Measure::getIntValue).orElse(0);
        if (skipped > 0) {
            String message = String.format("Fix or remove skipped unit tests in file \"%s\".", file.getName());
            return new CommonRule.CommonRuleIssue(skipped, message);
        }
        return null;
    }
}

