/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.measure;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.SetMultimap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.sonar.ce.task.projectanalysis.component.Component;
import org.sonar.ce.task.projectanalysis.measure.Measure;
import org.sonar.ce.task.projectanalysis.measure.MeasureKey;
import org.sonar.ce.task.projectanalysis.measure.MeasureRepository;
import org.sonar.ce.task.projectanalysis.metric.Metric;

public final class MapBasedRawMeasureRepository<T>
implements MeasureRepository {
    private final Function<Component, T> componentToKey;
    private final Map<T, Map<MeasureKey, Measure>> measures = new HashMap<T, Map<MeasureKey, Measure>>();

    public MapBasedRawMeasureRepository(Function<Component, T> componentToKey) {
        this.componentToKey = Objects.requireNonNull(componentToKey);
    }

    @Override
    public Optional<Measure> getBaseMeasure(Component component, Metric metric) {
        throw new UnsupportedOperationException("This implementation of MeasureRepository supports only raw measures");
    }

    @Override
    public Optional<Measure> getRawMeasure(Component component, Metric metric) {
        Objects.requireNonNull(component);
        Objects.requireNonNull(metric);
        return this.find(component, metric);
    }

    @Override
    public void add(Component component, Metric metric, Measure measure) {
        Objects.requireNonNull(component);
        MapBasedRawMeasureRepository.checkValueTypeConsistency(metric, measure);
        Optional<Measure> existingMeasure = this.find(component, metric, measure);
        if (existingMeasure.isPresent()) {
            throw new UnsupportedOperationException(String.format("a measure can be set only once for a specific Component (key=%s), Metric (key=%s). Use update method", component.getDbKey(), metric.getKey()));
        }
        this.add(component, metric, measure, OverridePolicy.OVERRIDE);
    }

    @Override
    public void update(Component component, Metric metric, Measure measure) {
        Objects.requireNonNull(component);
        MapBasedRawMeasureRepository.checkValueTypeConsistency(metric, measure);
        Optional<Measure> existingMeasure = this.find(component, metric, measure);
        if (!existingMeasure.isPresent()) {
            throw new UnsupportedOperationException(String.format("a measure can be updated only if one already exists for a specific Component (key=%s), Metric (key=%s). Use add method", component.getDbKey(), metric.getKey()));
        }
        this.add(component, metric, measure, OverridePolicy.OVERRIDE);
    }

    private static void checkValueTypeConsistency(Metric metric, Measure measure) {
        Preconditions.checkArgument((measure.getValueType() == Measure.ValueType.NO_VALUE || measure.getValueType() == metric.getType().getValueType() ? 1 : 0) != 0, (String)"Measure's ValueType (%s) is not consistent with the Metric's ValueType (%s)", (Object[])new Object[]{measure.getValueType(), metric.getType().getValueType()});
    }

    @Override
    public Set<Measure> getRawMeasures(Component component, Metric metric) {
        Objects.requireNonNull(metric);
        Objects.requireNonNull(component);
        T componentKey = this.componentToKey.apply(component);
        Map<MeasureKey, Measure> rawMeasures = this.measures.get(componentKey);
        if (rawMeasures == null) {
            return Collections.emptySet();
        }
        return rawMeasures.entrySet().stream().filter(new MatchMetric(metric)).map(ToMeasure.INSTANCE).collect(Collectors.toSet());
    }

    @Override
    public SetMultimap<String, Measure> getRawMeasures(Component component) {
        T componentKey = this.componentToKey.apply(component);
        Map<MeasureKey, Measure> rawMeasures = this.measures.get(componentKey);
        if (rawMeasures == null) {
            return ImmutableSetMultimap.of();
        }
        ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
        for (Map.Entry<MeasureKey, Measure> entry : rawMeasures.entrySet()) {
            builder.put((Object)entry.getKey().getMetricKey(), (Object)entry.getValue());
        }
        return builder.build();
    }

    private Optional<Measure> find(Component component, Metric metric) {
        T componentKey = this.componentToKey.apply(component);
        Map<MeasureKey, Measure> measuresPerMetric = this.measures.get(componentKey);
        if (measuresPerMetric == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(measuresPerMetric.get(new MeasureKey(metric.getKey(), null)));
    }

    private Optional<Measure> find(Component component, Metric metric, Measure measure) {
        T componentKey = this.componentToKey.apply(component);
        Map<MeasureKey, Measure> measuresPerMetric = this.measures.get(componentKey);
        if (measuresPerMetric == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(measuresPerMetric.get(new MeasureKey(metric.getKey(), measure.getDeveloper())));
    }

    public void add(Component component, Metric metric, Measure measure, OverridePolicy overridePolicy) {
        Objects.requireNonNull(component);
        Objects.requireNonNull(measure);
        Objects.requireNonNull(measure);
        Objects.requireNonNull(overridePolicy);
        T componentKey = this.componentToKey.apply(component);
        Map measuresPerMetric = this.measures.computeIfAbsent(componentKey, key -> new HashMap());
        MeasureKey key2 = new MeasureKey(metric.getKey(), measure.getDeveloper());
        if (!measuresPerMetric.containsKey(key2) || overridePolicy == OverridePolicy.OVERRIDE) {
            measuresPerMetric.put(key2, measure);
        }
    }

    private static enum ToMeasure implements Function<Map.Entry<MeasureKey, Measure>, Measure>
    {
        INSTANCE;


        @Override
        @Nullable
        public Measure apply(@Nonnull Map.Entry<MeasureKey, Measure> input) {
            return input.getValue();
        }
    }

    private static class MatchMetric
    implements Predicate<Map.Entry<MeasureKey, Measure>> {
        private final Metric metric;

        public MatchMetric(Metric metric) {
            this.metric = metric;
        }

        @Override
        public boolean test(@Nonnull Map.Entry<MeasureKey, Measure> input) {
            return input.getKey().getMetricKey().equals(this.metric.getKey());
        }
    }

    public static enum OverridePolicy {
        OVERRIDE,
        DO_NOT_OVERRIDE;

    }
}

