/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.metric;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.sonar.ce.task.projectanalysis.measure.Measure;
import org.sonar.ce.task.projectanalysis.metric.Metric;

@Immutable
public final class MetricImpl
implements Metric {
    private final int id;
    private final String key;
    private final String name;
    private final Metric.MetricType type;
    private final Integer decimalScale;
    private final Double bestValue;
    private final boolean bestValueOptimized;

    public MetricImpl(int id, String key, String name, Metric.MetricType type) {
        this(id, key, name, type, null, null, false);
    }

    public MetricImpl(int id, String key, String name, Metric.MetricType type, @Nullable Integer decimalScale, @Nullable Double bestValue, boolean bestValueOptimized) {
        Preconditions.checkArgument((!bestValueOptimized || bestValue != null ? 1 : 0) != 0, (Object)"A BestValue must be specified if Metric is bestValueOptimized");
        this.id = id;
        this.key = (String)Preconditions.checkNotNull((Object)key);
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this.type = (Metric.MetricType)((Object)Preconditions.checkNotNull((Object)((Object)type)));
        this.decimalScale = type.getValueType() == Measure.ValueType.DOUBLE ? (Integer)MoreObjects.firstNonNull((Object)decimalScale, (Object)1) : decimalScale;
        this.bestValueOptimized = bestValueOptimized;
        this.bestValue = bestValue;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Metric.MetricType getType() {
        return this.type;
    }

    @Override
    public int getDecimalScale() {
        Preconditions.checkState((this.decimalScale != null ? 1 : 0) != 0, (String)"Decimal scale is not defined on metric %s", (Object[])new Object[]{this.key});
        return this.decimalScale;
    }

    @Override
    @CheckForNull
    public Double getBestValue() {
        return this.bestValue;
    }

    @Override
    public boolean isBestValueOptimized() {
        return this.bestValueOptimized;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetricImpl metric = (MetricImpl)o;
        return Objects.equals(this.key, metric.key);
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", this.id).add("key", (Object)this.key).add("name", (Object)this.name).add("type", (Object)this.type).add("bestValue", (Object)this.bestValue).add("bestValueOptimized", this.bestValueOptimized).toString();
    }
}

