/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.metric;

import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.picocontainer.Startable;
import org.sonar.ce.task.projectanalysis.metric.Metric;
import org.sonar.ce.task.projectanalysis.metric.MetricDtoToMetric;
import org.sonar.ce.task.projectanalysis.metric.MetricRepository;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;

public class MetricRepositoryImpl
implements MetricRepository,
Startable {
    private final DbClient dbClient;
    @CheckForNull
    private Map<String, Metric> metricsByKey;
    @CheckForNull
    private Map<Long, Metric> metricsById;

    public MetricRepositoryImpl(DbClient dbClient) {
        this.dbClient = dbClient;
    }

    public void start() {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            List metricList = this.dbClient.metricDao().selectEnabled(dbSession);
            this.metricsByKey = FluentIterable.from((Iterable)metricList).transform((Function)MetricDtoToMetric.INSTANCE).uniqueIndex((Function)MetricToKey.INSTANCE);
            this.metricsById = FluentIterable.from((Iterable)metricList).transform((Function)MetricDtoToMetric.INSTANCE).uniqueIndex((Function)MetricToId.INSTANCE);
        }
    }

    public void stop() {
    }

    @Override
    public Metric getByKey(String key) {
        Objects.requireNonNull(key);
        this.verifyMetricsInitialized();
        Metric res = this.metricsByKey.get(key);
        if (res == null) {
            throw new IllegalStateException(String.format("Metric with key '%s' does not exist", key));
        }
        return res;
    }

    @Override
    public Metric getById(long id) {
        return this.getOptionalById(id).orElseThrow(() -> new IllegalStateException(String.format("Metric with id '%s' does not exist", id)));
    }

    @Override
    public Optional<Metric> getOptionalById(long id) {
        this.verifyMetricsInitialized();
        return Optional.ofNullable(this.metricsById.get(id));
    }

    @Override
    public Iterable<Metric> getAll() {
        return FluentIterable.from(this.metricsByKey.values()).toSet();
    }

    private void verifyMetricsInitialized() {
        if (this.metricsByKey == null) {
            throw new IllegalStateException("Metric cache has not been initialized");
        }
    }

    private static enum MetricToId implements Function<Metric, Long>
    {
        INSTANCE;


        @Nonnull
        public Long apply(@Nonnull Metric metric) {
            return metric.getId();
        }
    }

    private static enum MetricToKey implements Function<Metric, String>
    {
        INSTANCE;


        @Nonnull
        public String apply(@Nonnull Metric metric) {
            return metric.getKey();
        }
    }
}

