/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.notification;

import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Map;
import org.sonar.api.notifications.Notification;
import org.sonar.api.notifications.NotificationChannel;
import org.sonar.server.notification.NotificationDispatcher;
import org.sonar.server.notification.NotificationDispatcherMetadata;
import org.sonar.server.notification.NotificationManager;

public class ReportAnalysisFailureNotificationDispatcher
extends NotificationDispatcher {
    public static final String KEY = "CeReportTaskFailure";
    private static final NotificationManager.SubscriberPermissionsOnProject REQUIRED_SUBSCRIBER_PERMISSIONS = new NotificationManager.SubscriberPermissionsOnProject("admin", "user");
    private final NotificationManager manager;

    public ReportAnalysisFailureNotificationDispatcher(NotificationManager manager) {
        super("ce-report-task-failure");
        this.manager = manager;
    }

    public static NotificationDispatcherMetadata newMetadata() {
        return NotificationDispatcherMetadata.create((String)KEY).setProperty("globalNotification", String.valueOf(true)).setProperty("perProjectNotification", String.valueOf(true));
    }

    public String getKey() {
        return KEY;
    }

    public void dispatch(Notification notification, NotificationDispatcher.Context context) {
        String projectKey = notification.getFieldValue("project.key");
        Multimap subscribedRecipients = this.manager.findSubscribedRecipientsForDispatcher((NotificationDispatcher)this, projectKey, REQUIRED_SUBSCRIBER_PERMISSIONS);
        for (Map.Entry channelsByRecipients : subscribedRecipients.asMap().entrySet()) {
            String userLogin = (String)channelsByRecipients.getKey();
            for (NotificationChannel channel : (Collection)channelsByRecipients.getValue()) {
                context.addUser(userLogin, channel);
            }
        }
    }
}

