/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.notification;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.sonar.api.config.EmailSettings;
import org.sonar.api.notifications.Notification;
import org.sonar.api.utils.DateUtils;
import org.sonar.ce.task.projectanalysis.notification.ReportAnalysisFailureNotification;
import org.sonar.ce.task.projectanalysis.notification.ReportAnalysisFailureNotificationSerializer;
import org.sonar.plugins.emailnotifications.api.EmailMessage;
import org.sonar.plugins.emailnotifications.api.EmailTemplate;

public class ReportAnalysisFailureNotificationEmailTemplate
extends EmailTemplate {
    private static final char LINE_RETURN = '\n';
    private static final char TAB = '\t';
    private final ReportAnalysisFailureNotificationSerializer serializer;
    protected final EmailSettings settings;

    public ReportAnalysisFailureNotificationEmailTemplate(ReportAnalysisFailureNotificationSerializer serializer, EmailSettings settings) {
        this.serializer = serializer;
        this.settings = settings;
    }

    public EmailMessage format(Notification notification) {
        if (!"ce-report-task-failure".equals(notification.getType())) {
            return null;
        }
        ReportAnalysisFailureNotification taskFailureNotification = this.serializer.fromNotification(notification);
        String projectUuid = taskFailureNotification.getProject().getUuid();
        String projectFullName = ReportAnalysisFailureNotificationEmailTemplate.computeProjectFullName(taskFailureNotification.getProject());
        return new EmailMessage().setMessageId(notification.getType() + "/" + projectUuid).setSubject(ReportAnalysisFailureNotificationEmailTemplate.subject(projectFullName)).setMessage(this.message(projectFullName, taskFailureNotification));
    }

    private static String computeProjectFullName(ReportAnalysisFailureNotification.Project project) {
        String branchName = project.getBranchName();
        if (branchName != null) {
            return String.format("%s (%s)", project.getName(), branchName);
        }
        return project.getName();
    }

    private static String subject(String projectFullName) {
        return String.format("%s: Background task in failure", projectFullName);
    }

    private String message(String projectFullName, ReportAnalysisFailureNotification taskFailureNotification) {
        ReportAnalysisFailureNotification.Project project = taskFailureNotification.getProject();
        ReportAnalysisFailureNotification.Task task = taskFailureNotification.getTask();
        StringBuilder res = new StringBuilder();
        res.append("Project:").append('\t').append(projectFullName).append('\n');
        res.append("Background task:").append('\t').append(task.getUuid()).append('\n');
        res.append("Submission time:").append('\t').append(DateUtils.formatDateTime((long)task.getCreatedAt())).append('\n');
        res.append("Failure time:").append('\t').append(DateUtils.formatDateTime((long)task.getFailedAt())).append('\n');
        String errorMessage = taskFailureNotification.getErrorMessage();
        if (errorMessage != null) {
            res.append('\n');
            res.append("Error message:").append('\t').append(errorMessage).append('\n');
        }
        res.append('\n');
        res.append("More details at: ").append(String.format("%s/project/background_tasks?id=%s", this.settings.getServerBaseURL(), ReportAnalysisFailureNotificationEmailTemplate.encode(project.getKey())));
        return res.toString();
    }

    private static String encode(String toEncode) {
        try {
            return URLEncoder.encode(toEncode, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Encoding not supported", e);
        }
    }
}

