/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.purge;

import org.sonar.ce.task.projectanalysis.analysis.AnalysisMetadataHolder;
import org.sonar.ce.task.projectanalysis.component.Component;
import org.sonar.ce.task.projectanalysis.component.ComponentVisitor;
import org.sonar.ce.task.projectanalysis.component.ConfigurationRepository;
import org.sonar.ce.task.projectanalysis.component.CrawlerDepthLimit;
import org.sonar.ce.task.projectanalysis.component.DepthTraversalTypeAwareCrawler;
import org.sonar.ce.task.projectanalysis.component.DisabledComponentsHolder;
import org.sonar.ce.task.projectanalysis.component.TreeRootHolder;
import org.sonar.ce.task.projectanalysis.component.TypeAwareVisitorAdapter;
import org.sonar.ce.task.projectanalysis.purge.ProjectCleaner;
import org.sonar.ce.task.step.ComputationStep;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;

public class PurgeDatastoresStep
implements ComputationStep {
    private final ProjectCleaner projectCleaner;
    private final DbClient dbClient;
    private final TreeRootHolder treeRootHolder;
    private final ConfigurationRepository configRepository;
    private final DisabledComponentsHolder disabledComponentsHolder;
    private final AnalysisMetadataHolder analysisMetadataHolder;

    public PurgeDatastoresStep(DbClient dbClient, ProjectCleaner projectCleaner, TreeRootHolder treeRootHolder, ConfigurationRepository configRepository, DisabledComponentsHolder disabledComponentsHolder, AnalysisMetadataHolder analysisMetadataHolder) {
        this.projectCleaner = projectCleaner;
        this.dbClient = dbClient;
        this.treeRootHolder = treeRootHolder;
        this.configRepository = configRepository;
        this.disabledComponentsHolder = disabledComponentsHolder;
        this.analysisMetadataHolder = analysisMetadataHolder;
    }

    public void execute(ComputationStep.Context context) {
        new DepthTraversalTypeAwareCrawler(new TypeAwareVisitorAdapter(CrawlerDepthLimit.reportMaxDepth(Component.Type.PROJECT).withViewsMaxDepth(Component.Type.VIEW), ComponentVisitor.Order.PRE_ORDER){

            @Override
            public void visitProject(Component project) {
                PurgeDatastoresStep.this.execute(project);
            }

            @Override
            public void visitView(Component view) {
                PurgeDatastoresStep.this.execute(view);
            }
        }).visit(this.treeRootHolder.getRoot());
    }

    private void execute(Component root) {
        try (DbSession dbSession = this.dbClient.openSession(true);){
            String projectUuid = this.analysisMetadataHolder.getProject().getUuid();
            this.projectCleaner.purge(dbSession, root.getUuid(), projectUuid, this.configRepository.getConfiguration(), this.disabledComponentsHolder.getUuids());
            dbSession.commit();
        }
    }

    public String getDescription() {
        return "Purge db";
    }
}

