/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.qualitygate;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.sonar.ce.task.projectanalysis.metric.Metric;

@Immutable
public class Condition {
    private final Metric metric;
    private final Operator operator;
    private final String errorThreshold;
    private final boolean useVariation;

    public Condition(Metric metric, String operator, String errorThreshold) {
        this.metric = Objects.requireNonNull(metric);
        this.operator = Condition.parseFromDbValue(Objects.requireNonNull(operator));
        this.useVariation = metric.getKey().startsWith("new_");
        this.errorThreshold = errorThreshold;
    }

    private static Operator parseFromDbValue(String str) {
        for (Operator operator : Operator.values()) {
            if (!operator.dbValue.equals(str)) continue;
            return operator;
        }
        throw new IllegalArgumentException(String.format("Unsupported operator value: '%s'", str));
    }

    public Metric getMetric() {
        return this.metric;
    }

    public boolean useVariation() {
        return this.useVariation;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public String getErrorThreshold() {
        return this.errorThreshold;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Condition that = (Condition)o;
        return Objects.equals(this.metric, that.metric);
    }

    public int hashCode() {
        return Objects.hash(this.metric);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("metric", (Object)this.metric).add("operator", (Object)this.operator).add("errorThreshold", (Object)this.errorThreshold).toString();
    }

    public static enum Operator {
        GREATER_THAN("GT"),
        LESS_THAN("LT");

        private final String dbValue;

        private Operator(String dbValue) {
            this.dbValue = dbValue;
        }

        public String getDbValue() {
            return this.dbValue;
        }
    }
}

