/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.qualitygate;

import com.google.common.base.Preconditions;
import java.util.EnumSet;
import java.util.Optional;
import javax.annotation.CheckForNull;
import org.sonar.ce.task.projectanalysis.measure.Measure;
import org.sonar.ce.task.projectanalysis.metric.Metric;
import org.sonar.ce.task.projectanalysis.qualitygate.Condition;
import org.sonar.ce.task.projectanalysis.qualitygate.EvaluationResult;

public final class ConditionEvaluator {
    private static final EnumSet<Metric.MetricType> SUPPORTED_METRIC_TYPE = EnumSet.of(Metric.MetricType.INT, new Metric.MetricType[]{Metric.MetricType.MILLISEC, Metric.MetricType.RATING, Metric.MetricType.WORK_DUR, Metric.MetricType.FLOAT, Metric.MetricType.PERCENT, Metric.MetricType.LEVEL});

    public EvaluationResult evaluate(Condition condition, Measure measure) {
        Preconditions.checkArgument((boolean)SUPPORTED_METRIC_TYPE.contains((Object)condition.getMetric().getType()), (String)"Conditions on MetricType %s are not supported", (Object[])new Object[]{condition.getMetric().getType()});
        Comparable measureComparable = ConditionEvaluator.parseMeasure(condition, measure);
        if (measureComparable == null) {
            return new EvaluationResult(Measure.Level.OK, null);
        }
        return ConditionEvaluator.evaluateCondition(condition, measureComparable).orElseGet(() -> new EvaluationResult(Measure.Level.OK, measureComparable));
    }

    private static Optional<EvaluationResult> evaluateCondition(Condition condition, Comparable<?> measureComparable) {
        try {
            Comparable conditionComparable = ConditionEvaluator.parseConditionValue(condition.getMetric(), condition.getErrorThreshold());
            if (ConditionEvaluator.doesReachThresholds(measureComparable, conditionComparable, condition)) {
                return Optional.of(new EvaluationResult(Measure.Level.ERROR, measureComparable));
            }
            return Optional.empty();
        }
        catch (NumberFormatException badValueFormat) {
            throw new IllegalArgumentException(String.format("Quality Gate: Unable to parse value '%s' to compare against %s", condition.getErrorThreshold(), condition.getMetric().getName()));
        }
    }

    private static boolean doesReachThresholds(Comparable measureValue, Comparable criteriaValue, Condition condition) {
        int comparison = measureValue.compareTo(criteriaValue);
        switch (condition.getOperator()) {
            case GREATER_THAN: {
                return comparison > 0;
            }
            case LESS_THAN: {
                return comparison < 0;
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported operator '%s'", new Object[]{condition.getOperator()}));
    }

    private static Comparable parseConditionValue(Metric metric, String value) {
        switch (metric.getType().getValueType()) {
            case INT: {
                return ConditionEvaluator.parseInteger(value);
            }
            case LONG: {
                return Long.valueOf(Long.parseLong(value));
            }
            case DOUBLE: {
                return Double.valueOf(Double.parseDouble(value));
            }
            case LEVEL: {
                return value;
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported value type %s. Can not convert condition value", new Object[]{metric.getType().getValueType()}));
    }

    private static Comparable<Integer> parseInteger(String value) {
        return value.contains(".") ? Integer.parseInt(value.substring(0, value.indexOf(46))) : Integer.parseInt(value);
    }

    @CheckForNull
    private static Comparable parseMeasure(Condition condition, Measure measure) {
        if (condition.useVariation()) {
            return ConditionEvaluator.parseMeasureFromVariation(condition, measure);
        }
        switch (measure.getValueType()) {
            case INT: {
                return Integer.valueOf(measure.getIntValue());
            }
            case LONG: {
                return Long.valueOf(measure.getLongValue());
            }
            case DOUBLE: {
                return Double.valueOf(measure.getDoubleValue());
            }
            case LEVEL: {
                return measure.getLevelValue().name();
            }
            case NO_VALUE: {
                return null;
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported measure ValueType %s. Can not parse measure to a Comparable", new Object[]{measure.getValueType()}));
    }

    @CheckForNull
    private static Comparable parseMeasureFromVariation(Condition condition, Measure measure) {
        if (!measure.hasVariation()) {
            return null;
        }
        Double variation = measure.getVariation();
        Metric.MetricType metricType = condition.getMetric().getType();
        switch (metricType.getValueType()) {
            case INT: {
                return Integer.valueOf(variation.intValue());
            }
            case LONG: {
                return Long.valueOf(variation.longValue());
            }
            case DOUBLE: {
                return variation;
            }
        }
        throw new IllegalArgumentException("Unsupported metric type " + (Object)((Object)metricType));
    }
}

