/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.qualitygate;

import com.google.common.collect.ImmutableMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckForNull;
import org.sonar.api.i18n.I18n;
import org.sonar.api.utils.Duration;
import org.sonar.api.utils.Durations;
import org.sonar.ce.task.projectanalysis.measure.Measure;
import org.sonar.ce.task.projectanalysis.metric.Metric;
import org.sonar.ce.task.projectanalysis.qualitygate.Condition;
import org.sonar.ce.task.projectanalysis.qualitygate.EvaluationResult;
import org.sonar.ce.task.projectanalysis.qualitygate.EvaluationResultTextConverter;

public final class EvaluationResultTextConverterImpl
implements EvaluationResultTextConverter {
    private static final Map<Condition.Operator, String> OPERATOR_LABELS = ImmutableMap.of((Object)((Object)Condition.Operator.GREATER_THAN), (Object)">", (Object)((Object)Condition.Operator.LESS_THAN), (Object)"<");
    private final I18n i18n;
    private final Durations durations;

    public EvaluationResultTextConverterImpl(I18n i18n, Durations durations) {
        this.i18n = i18n;
        this.durations = durations;
    }

    @Override
    @CheckForNull
    public String asText(Condition condition, EvaluationResult evaluationResult) {
        Objects.requireNonNull(condition);
        if (evaluationResult.getLevel() == Measure.Level.OK) {
            return null;
        }
        return this.getAlertLabel(condition);
    }

    private String getAlertLabel(Condition condition) {
        String metric = this.i18n.message(Locale.ENGLISH, "metric." + condition.getMetric().getKey() + ".name", condition.getMetric().getName(), new Object[0]);
        return metric + " " + OPERATOR_LABELS.get((Object)condition.getOperator()) + " " + this.alertValue(condition);
    }

    private String alertValue(Condition condition) {
        if (condition.getMetric().getType() == Metric.MetricType.WORK_DUR) {
            return this.formatDuration(condition.getErrorThreshold());
        }
        return condition.getErrorThreshold();
    }

    private String formatDuration(String value) {
        return this.durations.format(Duration.create((long)Long.parseLong(value)));
    }
}

