/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.qualitymodel;

import java.util.Optional;
import org.sonar.ce.task.projectanalysis.component.Component;
import org.sonar.ce.task.projectanalysis.component.ComponentVisitor;
import org.sonar.ce.task.projectanalysis.component.CrawlerDepthLimit;
import org.sonar.ce.task.projectanalysis.component.PathAwareVisitor;
import org.sonar.ce.task.projectanalysis.component.PathAwareVisitorAdapter;
import org.sonar.ce.task.projectanalysis.formula.counter.RatingValue;
import org.sonar.ce.task.projectanalysis.measure.Measure;
import org.sonar.ce.task.projectanalysis.measure.MeasureRepository;
import org.sonar.ce.task.projectanalysis.metric.Metric;
import org.sonar.ce.task.projectanalysis.metric.MetricRepository;
import org.sonar.ce.task.projectanalysis.qualitymodel.RatingSettings;
import org.sonar.server.measure.Rating;

public class MaintainabilityMeasuresVisitor
extends PathAwareVisitorAdapter<Counter> {
    private final MeasureRepository measureRepository;
    private final RatingSettings ratingSettings;
    private final Metric nclocMetric;
    private final Metric developmentCostMetric;
    private final Metric maintainabilityRemediationEffortMetric;
    private final Metric debtRatioMetric;
    private final Metric maintainabilityRatingMetric;
    private final Metric effortToMaintainabilityRatingAMetric;

    public MaintainabilityMeasuresVisitor(MetricRepository metricRepository, MeasureRepository measureRepository, RatingSettings ratingSettings) {
        super(CrawlerDepthLimit.FILE, ComponentVisitor.Order.POST_ORDER, CounterFactory.INSTANCE);
        this.measureRepository = measureRepository;
        this.ratingSettings = ratingSettings;
        this.nclocMetric = metricRepository.getByKey("ncloc");
        this.maintainabilityRemediationEffortMetric = metricRepository.getByKey("sqale_index");
        this.developmentCostMetric = metricRepository.getByKey("development_cost");
        this.debtRatioMetric = metricRepository.getByKey("sqale_debt_ratio");
        this.maintainabilityRatingMetric = metricRepository.getByKey("sqale_rating");
        this.effortToMaintainabilityRatingAMetric = metricRepository.getByKey("effort_to_reach_maintainability_rating_a");
    }

    @Override
    public void visitProject(Component project, PathAwareVisitor.Path<Counter> path) {
        this.computeAndSaveMeasures(project, path);
    }

    @Override
    public void visitDirectory(Component directory, PathAwareVisitor.Path<Counter> path) {
        this.computeAndSaveMeasures(directory, path);
    }

    @Override
    public void visitFile(Component file, PathAwareVisitor.Path<Counter> path) {
        path.current().addDevCosts(this.computeDevelopmentCost(file));
        this.computeAndSaveMeasures(file, path);
    }

    private long computeDevelopmentCost(Component file) {
        Optional<Measure> measure = this.measureRepository.getRawMeasure(file, this.nclocMetric);
        long ncloc = measure.map(Measure::getIntValue).orElse(0).intValue();
        return ncloc * this.ratingSettings.getDevCost(file.getFileAttributes().getLanguageKey());
    }

    private void computeAndSaveMeasures(Component component, PathAwareVisitor.Path<Counter> path) {
        this.addDevelopmentCostMeasure(component, path.current());
        double density = this.computeDensity(component, path.current());
        this.addDebtRatioMeasure(component, density);
        this.addMaintainabilityRatingMeasure(component, density);
        this.addEffortToMaintainabilityRatingAMeasure(component, path);
        MaintainabilityMeasuresVisitor.addToParent(path);
    }

    private double computeDensity(Component component, Counter developmentCost) {
        double maintainabilityRemediationEffort;
        Optional<Measure> measure = this.measureRepository.getRawMeasure(component, this.maintainabilityRemediationEffortMetric);
        double d = maintainabilityRemediationEffort = measure.isPresent() ? (double)measure.get().getLongValue() : 0.0;
        if (Double.doubleToRawLongBits(developmentCost.devCosts) != 0L) {
            return maintainabilityRemediationEffort / (double)developmentCost.devCosts;
        }
        return 0.0;
    }

    private void addDevelopmentCostMeasure(Component component, Counter developmentCost) {
        this.measureRepository.add(component, this.developmentCostMetric, Measure.newMeasureBuilder().create(Long.toString(developmentCost.devCosts)));
    }

    private void addDebtRatioMeasure(Component component, double density) {
        this.measureRepository.add(component, this.debtRatioMetric, Measure.newMeasureBuilder().create(100.0 * density, this.debtRatioMetric.getDecimalScale()));
    }

    private void addMaintainabilityRatingMeasure(Component component, double density) {
        Rating rating = this.ratingSettings.getDebtRatingGrid().getRatingForDensity(density);
        this.measureRepository.add(component, this.maintainabilityRatingMetric, Measure.newMeasureBuilder().create(rating.getIndex(), rating.name()));
    }

    private void addEffortToMaintainabilityRatingAMeasure(Component component, PathAwareVisitor.Path<Counter> path) {
        long developmentCostValue = path.current().devCosts;
        Optional<Measure> effortMeasure = this.measureRepository.getRawMeasure(component, this.maintainabilityRemediationEffortMetric);
        long effort = effortMeasure.isPresent() ? effortMeasure.get().getLongValue() : 0L;
        long upperGradeCost = Double.valueOf(this.ratingSettings.getDebtRatingGrid().getGradeLowerBound(Rating.B) * (double)developmentCostValue).longValue();
        long effortToRatingA = upperGradeCost < effort ? effort - upperGradeCost : 0L;
        this.measureRepository.add(component, this.effortToMaintainabilityRatingAMetric, Measure.newMeasureBuilder().create(effortToRatingA));
    }

    private static void addToParent(PathAwareVisitor.Path<Counter> path) {
        if (!path.isRoot()) {
            path.parent().add(path.current());
        }
    }

    private static final class CounterFactory
    extends PathAwareVisitorAdapter.SimpleStackElementFactory<Counter> {
        public static final CounterFactory INSTANCE = new CounterFactory();

        private CounterFactory() {
        }

        @Override
        public Counter createForAny(Component component) {
            return new Counter();
        }
    }

    public static final class Counter {
        private long devCosts = 0L;
        private RatingValue reliabilityRating = new RatingValue();
        private RatingValue securityRating = new RatingValue();

        private Counter() {
        }

        void add(Counter otherCounter) {
            this.addDevCosts(otherCounter.devCosts);
            this.reliabilityRating.increment(otherCounter.reliabilityRating);
            this.securityRating.increment(otherCounter.securityRating);
        }

        void addDevCosts(long developmentCosts) {
            this.devCosts += developmentCosts;
        }
    }
}

