/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.qualitymodel;

import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonar.api.utils.KeyValueFormat;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.ce.task.projectanalysis.component.Component;
import org.sonar.ce.task.projectanalysis.component.ComponentVisitor;
import org.sonar.ce.task.projectanalysis.component.CrawlerDepthLimit;
import org.sonar.ce.task.projectanalysis.component.PathAwareVisitor;
import org.sonar.ce.task.projectanalysis.component.PathAwareVisitorAdapter;
import org.sonar.ce.task.projectanalysis.formula.counter.LongValue;
import org.sonar.ce.task.projectanalysis.measure.Measure;
import org.sonar.ce.task.projectanalysis.measure.MeasureRepository;
import org.sonar.ce.task.projectanalysis.metric.Metric;
import org.sonar.ce.task.projectanalysis.metric.MetricRepository;
import org.sonar.ce.task.projectanalysis.qualitymodel.RatingSettings;
import org.sonar.ce.task.projectanalysis.source.NewLinesRepository;

public class NewMaintainabilityMeasuresVisitor
extends PathAwareVisitorAdapter<Counter> {
    private static final Logger LOG = Loggers.get(NewMaintainabilityMeasuresVisitor.class);
    private final MeasureRepository measureRepository;
    private final NewLinesRepository newLinesRepository;
    private final RatingSettings ratingSettings;
    private final Metric newDebtMetric;
    private final Metric nclocDataMetric;
    private final Metric newDevelopmentCostMetric;
    private final Metric newDebtRatioMetric;
    private final Metric newMaintainabilityRatingMetric;

    public NewMaintainabilityMeasuresVisitor(MetricRepository metricRepository, MeasureRepository measureRepository, NewLinesRepository newLinesRepository, RatingSettings ratingSettings) {
        super(CrawlerDepthLimit.FILE, ComponentVisitor.Order.POST_ORDER, CounterFactory.INSTANCE);
        this.measureRepository = measureRepository;
        this.newLinesRepository = newLinesRepository;
        this.ratingSettings = ratingSettings;
        this.newDebtMetric = metricRepository.getByKey("new_technical_debt");
        this.nclocDataMetric = metricRepository.getByKey("ncloc_data");
        this.newDevelopmentCostMetric = metricRepository.getByKey("new_development_cost");
        this.newDebtRatioMetric = metricRepository.getByKey("new_sqale_debt_ratio");
        this.newMaintainabilityRatingMetric = metricRepository.getByKey("new_maintainability_rating");
    }

    @Override
    public void visitProject(Component project, PathAwareVisitor.Path<Counter> path) {
        this.computeAndSaveNewDebtRatioMeasure(project, path);
    }

    @Override
    public void visitDirectory(Component directory, PathAwareVisitor.Path<Counter> path) {
        this.computeAndSaveNewDebtRatioMeasure(directory, path);
        NewMaintainabilityMeasuresVisitor.increaseNewDebtAndDevCostOfParent(path);
    }

    @Override
    public void visitFile(Component file, PathAwareVisitor.Path<Counter> path) {
        this.initNewDebtRatioCounter(file, path);
        this.computeAndSaveNewDebtRatioMeasure(file, path);
        NewMaintainabilityMeasuresVisitor.increaseNewDebtAndDevCostOfParent(path);
    }

    private void computeAndSaveNewDebtRatioMeasure(Component component, PathAwareVisitor.Path<Counter> path) {
        if (!this.newLinesRepository.newLinesAvailable()) {
            return;
        }
        double density = NewMaintainabilityMeasuresVisitor.computeDensity(path.current());
        double newDebtRatio = 100.0 * density;
        double newMaintainability = this.ratingSettings.getDebtRatingGrid().getRatingForDensity(density).getIndex();
        long newDevelopmentCost = path.current().getDevCost().getValue();
        this.measureRepository.add(component, this.newDevelopmentCostMetric, Measure.newMeasureBuilder().setVariation(newDevelopmentCost).createNoValue());
        this.measureRepository.add(component, this.newDebtRatioMetric, Measure.newMeasureBuilder().setVariation(newDebtRatio).createNoValue());
        this.measureRepository.add(component, this.newMaintainabilityRatingMetric, Measure.newMeasureBuilder().setVariation(newMaintainability).createNoValue());
    }

    private static double computeDensity(Counter counter) {
        long developmentCost;
        LongValue newDebt = counter.getNewDebt();
        if (newDebt.isSet() && (developmentCost = counter.getDevCost().getValue()) != 0L) {
            return (double)newDebt.getValue() / (double)developmentCost;
        }
        return 0.0;
    }

    private static long getLongValue(Optional<Measure> measure) {
        return measure.map(NewMaintainabilityMeasuresVisitor::getLongValue).orElse(0L);
    }

    private static long getLongValue(Measure measure) {
        if (measure.hasVariation()) {
            return (long)measure.getVariation();
        }
        return 0L;
    }

    private void initNewDebtRatioCounter(Component file, PathAwareVisitor.Path<Counter> path) {
        if (!this.newLinesRepository.newLinesAvailable()) {
            return;
        }
        Optional<Set<Integer>> changedLines = this.newLinesRepository.getNewLines(file);
        if (!changedLines.isPresent()) {
            LOG.trace(String.format("No information about changed lines is available for file '%s'. Dev cost will be zero.", file.getKey()));
            return;
        }
        Optional<Measure> nclocDataMeasure = this.measureRepository.getRawMeasure(file, this.nclocDataMetric);
        if (!nclocDataMeasure.isPresent()) {
            return;
        }
        this.initNewDebtRatioCounter(path.current(), file, nclocDataMeasure.get(), changedLines.get());
    }

    private void initNewDebtRatioCounter(Counter devCostCounter, Component file, Measure nclocDataMeasure, Set<Integer> changedLines) {
        boolean hasDevCost = false;
        long lineDevCost = this.ratingSettings.getDevCost(file.getFileAttributes().getLanguageKey());
        for (Integer nclocLineIndex : NewMaintainabilityMeasuresVisitor.nclocLineIndexes(nclocDataMeasure)) {
            if (!changedLines.contains(nclocLineIndex)) continue;
            devCostCounter.incrementDevCost(lineDevCost);
            hasDevCost = true;
        }
        if (hasDevCost) {
            long newDebt = NewMaintainabilityMeasuresVisitor.getLongValue(this.measureRepository.getRawMeasure(file, this.newDebtMetric));
            devCostCounter.incrementNewDebt(newDebt);
        }
    }

    private static void increaseNewDebtAndDevCostOfParent(PathAwareVisitor.Path<Counter> path) {
        path.parent().add(path.current());
    }

    private static Iterable<Integer> nclocLineIndexes(Measure nclocDataMeasure) {
        Map parsedNclocData = KeyValueFormat.parse((String)nclocDataMeasure.getData(), (KeyValueFormat.Converter)KeyValueFormat.newIntegerConverter(), (KeyValueFormat.Converter)KeyValueFormat.newIntegerConverter());
        return parsedNclocData.entrySet().stream().filter(entry -> (Integer)entry.getValue() == 1).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    private static class CounterFactory
    extends PathAwareVisitorAdapter.SimpleStackElementFactory<Counter> {
        public static final CounterFactory INSTANCE = new CounterFactory();

        private CounterFactory() {
        }

        @Override
        public Counter createForAny(Component component) {
            return new Counter();
        }
    }

    public static final class Counter {
        private final LongValue newDebt = new LongValue();
        private final LongValue devCost = new LongValue();

        public void add(Counter counter) {
            this.newDebt.increment(counter.newDebt);
            this.devCost.increment(counter.devCost);
        }

        LongValue incrementNewDebt(long value) {
            return this.newDebt.increment(value);
        }

        LongValue incrementDevCost(long value) {
            return this.devCost.increment(value);
        }

        LongValue getNewDebt() {
            return this.newDebt;
        }

        LongValue getDevCost() {
            return this.devCost;
        }
    }
}

