/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.qualityprofile;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.sonar.api.rule.RuleKey;
import org.sonar.ce.task.projectanalysis.qualityprofile.ActiveRule;
import org.sonar.ce.task.projectanalysis.qualityprofile.ActiveRulesHolder;

public class ActiveRulesHolderImpl
implements ActiveRulesHolder {
    private Map<RuleKey, ActiveRule> activeRulesByKey = null;

    @Override
    public Optional<ActiveRule> get(RuleKey ruleKey) {
        Preconditions.checkState((this.activeRulesByKey != null ? 1 : 0) != 0, (Object)"Active rules have not been initialized yet");
        return Optional.ofNullable(this.activeRulesByKey.get(ruleKey));
    }

    public Collection<ActiveRule> getAll() {
        Preconditions.checkState((this.activeRulesByKey != null ? 1 : 0) != 0, (Object)"Active rules have not been initialized yet");
        return this.activeRulesByKey.values();
    }

    public void set(Collection<ActiveRule> activeRules) {
        Objects.requireNonNull(activeRules, "Active rules cannot be null");
        Preconditions.checkState((this.activeRulesByKey == null ? 1 : 0) != 0, (Object)"Active rules have already been initialized");
        HashMap<RuleKey, ActiveRule> temp = new HashMap<RuleKey, ActiveRule>();
        for (ActiveRule activeRule : activeRules) {
            ActiveRule previousValue = temp.put(activeRule.getRuleKey(), activeRule);
            if (previousValue == null) continue;
            throw new IllegalArgumentException("Active rule must not be declared multiple times: " + activeRule.getRuleKey());
        }
        this.activeRulesByKey = ImmutableMap.copyOf(temp);
    }
}

