/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.scm;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.ce.task.projectanalysis.analysis.AnalysisMetadataHolder;
import org.sonar.ce.task.projectanalysis.batch.BatchReportReader;
import org.sonar.ce.task.projectanalysis.component.Component;
import org.sonar.ce.task.projectanalysis.scm.Changeset;
import org.sonar.ce.task.projectanalysis.scm.DbScmInfo;
import org.sonar.ce.task.projectanalysis.scm.GeneratedScmInfo;
import org.sonar.ce.task.projectanalysis.scm.ReportScmInfo;
import org.sonar.ce.task.projectanalysis.scm.ScmInfo;
import org.sonar.ce.task.projectanalysis.scm.ScmInfoDbLoader;
import org.sonar.ce.task.projectanalysis.scm.ScmInfoImpl;
import org.sonar.ce.task.projectanalysis.scm.ScmInfoRepository;
import org.sonar.ce.task.projectanalysis.source.SourceHashRepository;
import org.sonar.ce.task.projectanalysis.source.SourceLinesDiff;
import org.sonar.scanner.protocol.output.ScannerReport;

public class ScmInfoRepositoryImpl
implements ScmInfoRepository {
    private static final Logger LOGGER = Loggers.get(ScmInfoRepositoryImpl.class);
    private final BatchReportReader scannerReportReader;
    private final Map<Component, Optional<ScmInfo>> scmInfoCache = new HashMap<Component, Optional<ScmInfo>>();
    private final ScmInfoDbLoader scmInfoDbLoader;
    private final AnalysisMetadataHolder analysisMetadata;
    private final SourceLinesDiff sourceLinesDiff;
    private final SourceHashRepository sourceHashRepository;

    public ScmInfoRepositoryImpl(BatchReportReader scannerReportReader, AnalysisMetadataHolder analysisMetadata, ScmInfoDbLoader scmInfoDbLoader, SourceLinesDiff sourceLinesDiff, SourceHashRepository sourceHashRepository) {
        this.scannerReportReader = scannerReportReader;
        this.analysisMetadata = analysisMetadata;
        this.scmInfoDbLoader = scmInfoDbLoader;
        this.sourceLinesDiff = sourceLinesDiff;
        this.sourceHashRepository = sourceHashRepository;
    }

    @Override
    public Optional<ScmInfo> getScmInfo(Component component) {
        Objects.requireNonNull(component, "Component cannot be null");
        if (component.getType() != Component.Type.FILE) {
            return Optional.empty();
        }
        return this.scmInfoCache.computeIfAbsent(component, this::getScmInfoForComponent);
    }

    private Optional<ScmInfo> getScmInfoForComponent(Component component) {
        ScannerReport.Changesets changesets = this.scannerReportReader.readChangesets(component.getReportAttributes().getRef());
        if (changesets == null) {
            LOGGER.trace("No SCM info for file '{}'", (Object)component.getDbKey());
            return this.generateAndMergeDb(component, false);
        }
        if (changesets.getChangesetCount() == 0) {
            return this.generateAndMergeDb(component, changesets.getCopyFromPrevious());
        }
        return ScmInfoRepositoryImpl.getScmInfoFromReport(component, changesets);
    }

    private static Optional<ScmInfo> getScmInfoFromReport(Component file, ScannerReport.Changesets changesets) {
        LOGGER.trace("Reading SCM info from report for file '{}'", (Object)file.getDbKey());
        return Optional.of(new ReportScmInfo(changesets));
    }

    private Optional<ScmInfo> generateScmInfoForAllFile(Component file) {
        if (file.getFileAttributes().getLines() == 0) {
            return Optional.empty();
        }
        Set<Integer> newOrChangedLines = IntStream.rangeClosed(1, file.getFileAttributes().getLines()).boxed().collect(Collectors.toSet());
        return Optional.of(GeneratedScmInfo.create(this.analysisMetadata.getAnalysisDate(), newOrChangedLines));
    }

    private static ScmInfo removeAuthorAndRevision(ScmInfo info) {
        Map<Integer, Changeset> cleanedScmInfo = info.getAllChangesets().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ScmInfoRepositoryImpl.removeAuthorAndRevision((Changeset)e.getValue())));
        return new ScmInfoImpl(cleanedScmInfo);
    }

    private static Changeset removeAuthorAndRevision(Changeset changeset) {
        return Changeset.newChangesetBuilder().setDate(changeset.getDate()).build();
    }

    private Optional<ScmInfo> generateAndMergeDb(Component file, boolean keepAuthorAndRevision) {
        boolean fileUnchanged;
        Optional<DbScmInfo> dbInfoOpt = this.scmInfoDbLoader.getScmInfo(file);
        if (!dbInfoOpt.isPresent()) {
            return this.generateScmInfoForAllFile(file);
        }
        ScmInfo scmInfo = keepAuthorAndRevision ? (ScmInfo)dbInfoOpt.get() : ScmInfoRepositoryImpl.removeAuthorAndRevision(dbInfoOpt.get());
        boolean bl = fileUnchanged = file.getStatus() == Component.Status.SAME && this.sourceHashRepository.getRawSourceHash(file).equals(dbInfoOpt.get().fileHash());
        if (fileUnchanged) {
            return Optional.of(scmInfo);
        }
        int[] matchingLines = this.sourceLinesDiff.computeMatchingLines(file);
        return Optional.of(GeneratedScmInfo.create(this.analysisMetadata.getAnalysisDate(), matchingLines, scmInfo));
    }
}

