/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.source;

import java.util.Optional;
import org.sonar.ce.task.projectanalysis.batch.BatchReportReader;
import org.sonar.ce.task.projectanalysis.component.Component;
import org.sonar.core.hash.LineRange;
import org.sonar.core.util.CloseableIterator;
import org.sonar.scanner.protocol.output.ScannerReport;

public class SignificantCodeRepository {
    private final BatchReportReader reportReader;

    public SignificantCodeRepository(BatchReportReader reportReader) {
        this.reportReader = reportReader;
    }

    public Optional<LineRange[]> getRangesPerLine(Component component) {
        int numLines = component.getFileAttributes().getLines();
        Optional<CloseableIterator<ScannerReport.LineSgnificantCode>> opt = this.reportReader.readComponentSignificantCode(component.getReportAttributes().getRef());
        if (!opt.isPresent()) {
            return Optional.empty();
        }
        try (CloseableIterator<ScannerReport.LineSgnificantCode> significantCode = opt.get();){
            Optional<LineRange[]> optional = Optional.of(SignificantCodeRepository.toArray(significantCode, numLines));
            return optional;
        }
    }

    private static LineRange[] toArray(CloseableIterator<ScannerReport.LineSgnificantCode> lineRanges, int numLines) {
        LineRange[] ranges = new LineRange[numLines];
        ScannerReport.LineSgnificantCode currentLine = null;
        for (int i = 0; i < numLines; ++i) {
            if (currentLine == null) {
                if (!lineRanges.hasNext()) break;
                currentLine = (ScannerReport.LineSgnificantCode)lineRanges.next();
            }
            if (currentLine.getLine() != i + 1) continue;
            ranges[i] = new LineRange(currentLine.getStartOffset(), currentLine.getEndOffset());
            currentLine = null;
        }
        return ranges;
    }
}

