/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.source;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.ce.task.projectanalysis.batch.BatchReportReader;
import org.sonar.ce.task.projectanalysis.component.Component;
import org.sonar.ce.task.projectanalysis.duplication.DuplicationRepository;
import org.sonar.ce.task.projectanalysis.scm.Changeset;
import org.sonar.ce.task.projectanalysis.scm.ScmInfo;
import org.sonar.ce.task.projectanalysis.scm.ScmInfoRepository;
import org.sonar.ce.task.projectanalysis.source.NewLinesRepository;
import org.sonar.ce.task.projectanalysis.source.linereader.CoverageLineReader;
import org.sonar.ce.task.projectanalysis.source.linereader.DuplicationLineReader;
import org.sonar.ce.task.projectanalysis.source.linereader.HighlightingLineReader;
import org.sonar.ce.task.projectanalysis.source.linereader.IsNewLineReader;
import org.sonar.ce.task.projectanalysis.source.linereader.LineReader;
import org.sonar.ce.task.projectanalysis.source.linereader.RangeOffsetConverter;
import org.sonar.ce.task.projectanalysis.source.linereader.ScmLineReader;
import org.sonar.ce.task.projectanalysis.source.linereader.SymbolsLineReader;
import org.sonar.core.util.CloseableIterator;
import org.sonar.db.protobuf.DbFileSources;
import org.sonar.scanner.protocol.output.ScannerReport;

public class SourceLineReadersFactory {
    private final BatchReportReader reportReader;
    private final ScmInfoRepository scmInfoRepository;
    private final DuplicationRepository duplicationRepository;
    private final NewLinesRepository newLinesRepository;

    public SourceLineReadersFactory(BatchReportReader reportReader, ScmInfoRepository scmInfoRepository, DuplicationRepository duplicationRepository, NewLinesRepository newLinesRepository) {
        this.reportReader = reportReader;
        this.scmInfoRepository = scmInfoRepository;
        this.duplicationRepository = duplicationRepository;
        this.newLinesRepository = newLinesRepository;
    }

    public LineReaders getLineReaders(Component component) {
        ArrayList<LineReader> readers = new ArrayList<LineReader>();
        ArrayList closeables = new ArrayList();
        ScmLineReader scmLineReader = null;
        int componentRef = component.getReportAttributes().getRef();
        CloseableIterator<ScannerReport.LineCoverage> coverageIt = this.reportReader.readComponentCoverage(componentRef);
        closeables.add(coverageIt);
        readers.add(new CoverageLineReader((Iterator<ScannerReport.LineCoverage>)coverageIt));
        Optional<ScmInfo> scmInfoOptional = this.scmInfoRepository.getScmInfo(component);
        if (scmInfoOptional.isPresent()) {
            scmLineReader = new ScmLineReader(scmInfoOptional.get());
            readers.add(scmLineReader);
        }
        RangeOffsetConverter rangeOffsetConverter = new RangeOffsetConverter();
        CloseableIterator<ScannerReport.SyntaxHighlightingRule> highlightingIt = this.reportReader.readComponentSyntaxHighlighting(componentRef);
        closeables.add(highlightingIt);
        readers.add(new HighlightingLineReader(component, (Iterator<ScannerReport.SyntaxHighlightingRule>)highlightingIt, rangeOffsetConverter));
        CloseableIterator<ScannerReport.Symbol> symbolsIt = this.reportReader.readComponentSymbols(componentRef);
        closeables.add(symbolsIt);
        readers.add(new SymbolsLineReader(component, (Iterator<ScannerReport.Symbol>)symbolsIt, rangeOffsetConverter));
        readers.add(new DuplicationLineReader(this.duplicationRepository.getDuplications(component)));
        readers.add(new IsNewLineReader(this.newLinesRepository, component));
        return new LineReadersImpl(readers, scmLineReader, closeables);
    }

    @VisibleForTesting
    static final class LineReadersImpl
    implements LineReaders {
        final List<LineReader> readers;
        @Nullable
        final ScmLineReader scmLineReader;
        final List<CloseableIterator<?>> closeables;

        LineReadersImpl(List<LineReader> readers, @Nullable ScmLineReader scmLineReader, List<CloseableIterator<?>> closeables) {
            this.readers = readers;
            this.scmLineReader = scmLineReader;
            this.closeables = closeables;
        }

        @Override
        public void close() {
            for (CloseableIterator<?> reportIterator : this.closeables) {
                reportIterator.close();
            }
        }

        @Override
        public void read(DbFileSources.Line.Builder lineBuilder, Consumer<LineReader.ReadError> readErrorConsumer) {
            for (LineReader r : this.readers) {
                r.read(lineBuilder).ifPresent(readErrorConsumer);
            }
        }

        @Override
        @CheckForNull
        public Changeset getLatestChangeWithRevision() {
            return this.scmLineReader == null ? null : this.scmLineReader.getLatestChangeWithRevision();
        }
    }

    static interface LineReaders
    extends AutoCloseable {
        public void read(DbFileSources.Line.Builder var1, Consumer<LineReader.ReadError> var2);

        @CheckForNull
        public Changeset getLatestChangeWithRevision();

        @Override
        public void close();
    }
}

