/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.source;

import java.util.Collections;
import java.util.List;
import org.sonar.ce.task.projectanalysis.component.Component;
import org.sonar.ce.task.projectanalysis.source.SourceLinesDiff;
import org.sonar.ce.task.projectanalysis.source.SourceLinesDiffFinder;
import org.sonar.ce.task.projectanalysis.source.SourceLinesHashRepository;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.source.FileSourceDao;

public class SourceLinesDiffImpl
implements SourceLinesDiff {
    private final DbClient dbClient;
    private final FileSourceDao fileSourceDao;
    private final SourceLinesHashRepository sourceLinesHash;

    public SourceLinesDiffImpl(DbClient dbClient, FileSourceDao fileSourceDao, SourceLinesHashRepository sourceLinesHash) {
        this.dbClient = dbClient;
        this.fileSourceDao = fileSourceDao;
        this.sourceLinesHash = sourceLinesHash;
    }

    @Override
    public int[] computeMatchingLines(Component component) {
        List<String> database = this.getDBLines(component);
        List<String> report = this.getReportLines(component);
        return new SourceLinesDiffFinder().findMatchingLines(database, report);
    }

    private List<String> getDBLines(Component component) {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            List database = this.fileSourceDao.selectLineHashes(dbSession, component.getUuid());
            if (database == null) {
                List<String> list = Collections.emptyList();
                return list;
            }
            List list = database;
            return list;
        }
    }

    private List<String> getReportLines(Component component) {
        return this.sourceLinesHash.getLineHashesMatchingDBVersion(component);
    }
}

