/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.source.linereader;

import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;
import org.sonar.db.protobuf.DbFileSources;

@FunctionalInterface
public interface LineReader {
    public Optional<ReadError> read(DbFileSources.Line.Builder var1);

    @Immutable
    public static final class ReadError {
        private final Data data;
        private final int line;

        public ReadError(Data data, int line) {
            Objects.requireNonNull(data);
            Preconditions.checkArgument((line >= 0 ? 1 : 0) != 0);
            this.data = data;
            this.line = line;
        }

        public Data getData() {
            return this.data;
        }

        public int getLine() {
            return this.line;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ReadError readError = (ReadError)o;
            return this.line == readError.line && this.data == readError.data;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.data, this.line});
        }

        public String toString() {
            return "ReadError{data=" + (Object)((Object)this.data) + ", line=" + this.line + '}';
        }
    }

    public static enum Data {
        COVERAGE,
        DUPLICATION,
        HIGHLIGHTING,
        SCM,
        SYMBOLS;

    }
}

