/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.step;

import com.google.common.base.Preconditions;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.sonar.ce.task.projectanalysis.analysis.AnalysisMetadataHolder;
import org.sonar.ce.task.projectanalysis.batch.BatchReportReader;
import org.sonar.ce.task.projectanalysis.component.Component;
import org.sonar.ce.task.projectanalysis.component.ComponentVisitor;
import org.sonar.ce.task.projectanalysis.component.CrawlerDepthLimit;
import org.sonar.ce.task.projectanalysis.component.DepthTraversalTypeAwareCrawler;
import org.sonar.ce.task.projectanalysis.component.TreeRootHolder;
import org.sonar.ce.task.projectanalysis.component.TypeAwareVisitorAdapter;
import org.sonar.ce.task.projectanalysis.duplication.DetailedTextBlock;
import org.sonar.ce.task.projectanalysis.duplication.Duplicate;
import org.sonar.ce.task.projectanalysis.duplication.Duplication;
import org.sonar.ce.task.projectanalysis.duplication.DuplicationRepository;
import org.sonar.ce.task.projectanalysis.duplication.InExtendedProjectDuplicate;
import org.sonar.ce.task.projectanalysis.duplication.InProjectDuplicate;
import org.sonar.ce.task.projectanalysis.duplication.InnerDuplicate;
import org.sonar.ce.task.projectanalysis.duplication.TextBlock;
import org.sonar.ce.task.step.ComputationStep;
import org.sonar.core.util.CloseableIterator;
import org.sonar.scanner.protocol.output.ScannerReport;

public class LoadDuplicationsFromReportStep
implements ComputationStep {
    private final TreeRootHolder treeRootHolder;
    private final AnalysisMetadataHolder analysisMetadataHolder;
    private final BatchReportReader batchReportReader;
    private final DuplicationRepository duplicationRepository;

    public LoadDuplicationsFromReportStep(TreeRootHolder treeRootHolder, AnalysisMetadataHolder analysisMetadataHolder, BatchReportReader batchReportReader, DuplicationRepository duplicationRepository) {
        this.treeRootHolder = treeRootHolder;
        this.analysisMetadataHolder = analysisMetadataHolder;
        this.batchReportReader = batchReportReader;
        this.duplicationRepository = duplicationRepository;
    }

    public String getDescription() {
        return "Load duplications";
    }

    public void execute(ComputationStep.Context context) {
        DuplicationVisitor visitor = new DuplicationVisitor();
        new DepthTraversalTypeAwareCrawler(visitor).visit(this.treeRootHolder.getReportTreeRoot());
        context.getStatistics().add("duplications", (Object)visitor.count);
    }

    private class DuplicationVisitor
    extends TypeAwareVisitorAdapter {
        private int count;

        private DuplicationVisitor() {
            super(CrawlerDepthLimit.FILE, ComponentVisitor.Order.POST_ORDER);
            this.count = 0;
        }

        @Override
        public void visitFile(Component file) {
            try (CloseableIterator<ScannerReport.Duplication> duplications = LoadDuplicationsFromReportStep.this.batchReportReader.readComponentDuplications(file.getReportAttributes().getRef());){
                int idGenerator = 1;
                while (duplications.hasNext()) {
                    this.loadDuplications(file, (ScannerReport.Duplication)duplications.next(), idGenerator);
                    ++idGenerator;
                    ++this.count;
                }
            }
        }

        private void loadDuplications(Component file, ScannerReport.Duplication duplication, int id) {
            LoadDuplicationsFromReportStep.this.duplicationRepository.add(file, new Duplication(this.convert(duplication.getOriginPosition(), id), duplication.getDuplicateList().stream().map(new BatchDuplicateToCeDuplicate(file)).collect(Collectors.toList())));
        }

        private DetailedTextBlock convert(ScannerReport.TextRange textRange, int id) {
            return new DetailedTextBlock(id, textRange.getStartLine(), textRange.getEndLine());
        }
    }

    private class BatchDuplicateToCeDuplicate
    implements Function<ScannerReport.Duplicate, Duplicate> {
        private final Component file;

        private BatchDuplicateToCeDuplicate(Component file) {
            this.file = file;
        }

        @Override
        @Nonnull
        public Duplicate apply(@Nonnull ScannerReport.Duplicate input) {
            if (input.getOtherFileRef() != 0) {
                Preconditions.checkArgument((input.getOtherFileRef() != this.file.getReportAttributes().getRef().intValue() ? 1 : 0) != 0, (Object)"file and otherFile references can not be the same");
                Component otherComponent = LoadDuplicationsFromReportStep.this.treeRootHolder.getReportTreeComponentByRef(input.getOtherFileRef());
                if (LoadDuplicationsFromReportStep.this.analysisMetadataHolder.isSLBorPR() && otherComponent.getStatus() == Component.Status.SAME) {
                    return new InExtendedProjectDuplicate(otherComponent, this.convert(input.getRange()));
                }
                return new InProjectDuplicate(otherComponent, this.convert(input.getRange()));
            }
            return new InnerDuplicate(this.convert(input.getRange()));
        }

        private TextBlock convert(ScannerReport.TextRange textRange) {
            return new TextBlock(textRange.getStartLine(), textRange.getEndLine());
        }
    }
}

