/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.step;

import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.config.Configuration;
import org.sonar.ce.task.projectanalysis.analysis.AnalysisMetadataHolder;
import org.sonar.ce.task.projectanalysis.component.ConfigurationRepository;
import org.sonar.ce.task.projectanalysis.qualitygate.Condition;
import org.sonar.ce.task.projectanalysis.qualitygate.MutableQualityGateHolder;
import org.sonar.ce.task.projectanalysis.qualitygate.QualityGate;
import org.sonar.ce.task.projectanalysis.qualitygate.QualityGateService;
import org.sonar.ce.task.step.ComputationStep;

public class LoadQualityGateStep
implements ComputationStep {
    private static final String PROPERTY_PROJECT_QUALITY_GATE = "sonar.qualitygate";
    private final ConfigurationRepository configRepository;
    private final QualityGateService qualityGateService;
    private final MutableQualityGateHolder qualityGateHolder;
    private final AnalysisMetadataHolder analysisMetadataHolder;

    public LoadQualityGateStep(ConfigurationRepository settingsRepository, QualityGateService qualityGateService, MutableQualityGateHolder qualityGateHolder, AnalysisMetadataHolder analysisMetadataHolder) {
        this.configRepository = settingsRepository;
        this.qualityGateService = qualityGateService;
        this.qualityGateHolder = qualityGateHolder;
        this.analysisMetadataHolder = analysisMetadataHolder;
    }

    public void execute(ComputationStep.Context context) {
        Optional<QualityGate> qualityGate = this.getProjectQualityGate();
        if (!qualityGate.isPresent()) {
            qualityGate = Optional.of(this.getOrganizationDefaultQualityGate());
        }
        if (this.analysisMetadataHolder.isSLBorPR()) {
            qualityGate = LoadQualityGateStep.filterQGForSLB(qualityGate);
        }
        this.qualityGateHolder.setQualityGate(qualityGate.orElseThrow(() -> new IllegalStateException("Quality gate not present")));
    }

    private static Optional<QualityGate> filterQGForSLB(Optional<QualityGate> qualityGate) {
        return qualityGate.map(qg -> new QualityGate(qg.getId(), qg.getName(), qg.getConditions().stream().filter(Condition::useVariation).collect(Collectors.toList())));
    }

    private Optional<QualityGate> getProjectQualityGate() {
        Configuration config = this.configRepository.getConfiguration();
        String qualityGateSetting = config.get(PROPERTY_PROJECT_QUALITY_GATE).orElse(null);
        if (StringUtils.isBlank((String)qualityGateSetting)) {
            return Optional.empty();
        }
        try {
            long qualityGateId = Long.parseLong(qualityGateSetting);
            return this.qualityGateService.findById(qualityGateId);
        }
        catch (NumberFormatException e) {
            throw new IllegalStateException(String.format("Unsupported value (%s) in property %s", qualityGateSetting, PROPERTY_PROJECT_QUALITY_GATE), e);
        }
    }

    private QualityGate getOrganizationDefaultQualityGate() {
        return this.qualityGateService.findDefaultQualityGate(this.analysisMetadataHolder.getOrganization());
    }

    public String getDescription() {
        return "Load Quality gate";
    }
}

