/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.step;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.sonar.ce.task.projectanalysis.batch.BatchReportReader;
import org.sonar.ce.task.projectanalysis.component.Component;
import org.sonar.ce.task.projectanalysis.component.PathAwareCrawler;
import org.sonar.ce.task.projectanalysis.component.TreeRootHolder;
import org.sonar.ce.task.projectanalysis.formula.Counter;
import org.sonar.ce.task.projectanalysis.formula.CounterInitializationContext;
import org.sonar.ce.task.projectanalysis.formula.CreateMeasureContext;
import org.sonar.ce.task.projectanalysis.formula.Formula;
import org.sonar.ce.task.projectanalysis.formula.FormulaExecutorComponentVisitor;
import org.sonar.ce.task.projectanalysis.formula.counter.IntValue;
import org.sonar.ce.task.projectanalysis.formula.coverage.LinesAndConditionsWithUncoveredMetricKeys;
import org.sonar.ce.task.projectanalysis.formula.coverage.LinesAndConditionsWithUncoveredVariationFormula;
import org.sonar.ce.task.projectanalysis.formula.coverage.SingleWithUncoveredMetricKeys;
import org.sonar.ce.task.projectanalysis.formula.coverage.SingleWithUncoveredVariationFormula;
import org.sonar.ce.task.projectanalysis.measure.Measure;
import org.sonar.ce.task.projectanalysis.measure.MeasureRepository;
import org.sonar.ce.task.projectanalysis.metric.Metric;
import org.sonar.ce.task.projectanalysis.metric.MetricRepository;
import org.sonar.ce.task.projectanalysis.source.NewLinesRepository;
import org.sonar.ce.task.step.ComputationStep;
import org.sonar.core.util.CloseableIterator;
import org.sonar.scanner.protocol.output.ScannerReport;

public class NewCoverageMeasuresStep
implements ComputationStep {
    private static final List<Formula> FORMULAS = ImmutableList.of((Object)new NewCoverageFormula(), (Object)new NewBranchCoverageFormula(), (Object)new NewLineCoverageFormula());
    private final TreeRootHolder treeRootHolder;
    private final MetricRepository metricRepository;
    private final MeasureRepository measureRepository;
    private final NewLinesRepository newLinesRepository;
    private final BatchReportReader reportReader;

    public NewCoverageMeasuresStep(TreeRootHolder treeRootHolder, MeasureRepository measureRepository, MetricRepository metricRepository, NewLinesRepository newLinesRepository, BatchReportReader reportReader) {
        this.treeRootHolder = treeRootHolder;
        this.metricRepository = metricRepository;
        this.measureRepository = measureRepository;
        this.newLinesRepository = newLinesRepository;
        this.reportReader = reportReader;
    }

    public void execute(ComputationStep.Context context) {
        new PathAwareCrawler<FormulaExecutorComponentVisitor.Counters>(FormulaExecutorComponentVisitor.newBuilder(this.metricRepository, this.measureRepository).buildFor(Iterables.concat(NewLinesAndConditionsCoverageFormula.from(this.newLinesRepository, this.reportReader), FORMULAS))).visit(this.treeRootHolder.getRoot());
    }

    public String getDescription() {
        return "Compute new coverage";
    }

    public static final class NewCoverageCounter
    implements Counter<NewCoverageCounter> {
        private final IntValue newLines = new IntValue();
        private final IntValue newCoveredLines = new IntValue();
        private final IntValue newConditions = new IntValue();
        private final IntValue newCoveredConditions = new IntValue();
        private final NewLinesRepository newLinesRepository;
        private final BatchReportReader reportReader;

        NewCoverageCounter(NewLinesRepository newLinesRepository, BatchReportReader reportReader) {
            this.newLinesRepository = newLinesRepository;
            this.reportReader = reportReader;
        }

        @Override
        public void aggregate(NewCoverageCounter counter) {
            this.newLines.increment(counter.newLines);
            this.newCoveredLines.increment(counter.newCoveredLines);
            this.newConditions.increment(counter.newConditions);
            this.newCoveredConditions.increment(counter.newCoveredConditions);
        }

        @Override
        public void initialize(CounterInitializationContext context) {
            Component component = context.getLeaf();
            if (component.getType() != Component.Type.FILE) {
                return;
            }
            Optional<Set<Integer>> newLinesSet = this.newLinesRepository.getNewLines(component);
            if (!newLinesSet.isPresent()) {
                return;
            }
            this.newLines.increment(0);
            this.newCoveredLines.increment(0);
            this.newConditions.increment(0);
            this.newCoveredConditions.increment(0);
            try (CloseableIterator<ScannerReport.LineCoverage> lineCoverage = this.reportReader.readComponentCoverage(component.getReportAttributes().getRef());){
                while (lineCoverage.hasNext()) {
                    ScannerReport.LineCoverage line = (ScannerReport.LineCoverage)lineCoverage.next();
                    int lineId = line.getLine();
                    if (!newLinesSet.get().contains(lineId)) continue;
                    if (line.getHasHitsCase() == ScannerReport.LineCoverage.HasHitsCase.HITS) {
                        this.newLines.increment(1);
                        if (line.getHits()) {
                            this.newCoveredLines.increment(1);
                        }
                    }
                    if (line.getHasCoveredConditionsCase() != ScannerReport.LineCoverage.HasCoveredConditionsCase.COVERED_CONDITIONS) continue;
                    this.newConditions.increment(line.getConditions());
                    this.newCoveredConditions.increment(Math.min(line.getCoveredConditions(), line.getConditions()));
                }
            }
        }

        boolean hasNewCode() {
            return this.newLines.isSet();
        }

        int getNewLines() {
            return this.newLines.getValue();
        }

        int getNewCoveredLines() {
            return this.newCoveredLines.getValue();
        }

        int getNewConditions() {
            return this.newConditions.getValue();
        }

        int getNewCoveredConditions() {
            return this.newCoveredConditions.getValue();
        }
    }

    public static class NewLinesAndConditionsCoverageFormula
    implements Formula<NewCoverageCounter> {
        private final NewLinesRepository newLinesRepository;
        private final BatchReportReader reportReader;

        private NewLinesAndConditionsCoverageFormula(NewLinesRepository newLinesRepository, BatchReportReader reportReader) {
            this.newLinesRepository = newLinesRepository;
            this.reportReader = reportReader;
        }

        public static Iterable<Formula<NewCoverageCounter>> from(NewLinesRepository newLinesRepository, BatchReportReader reportReader) {
            return Collections.singleton(new NewLinesAndConditionsCoverageFormula(newLinesRepository, reportReader));
        }

        @Override
        public NewCoverageCounter createNewCounter() {
            return new NewCoverageCounter(this.newLinesRepository, this.reportReader);
        }

        @Override
        public Optional<Measure> createMeasure(NewCoverageCounter counter, CreateMeasureContext context) {
            if (counter.hasNewCode()) {
                int value = NewLinesAndConditionsCoverageFormula.computeValueForMetric(counter, context.getMetric());
                return Optional.of(Measure.newMeasureBuilder().setVariation(value).createNoValue());
            }
            return Optional.empty();
        }

        private static int computeValueForMetric(NewCoverageCounter counter, Metric metric) {
            if (metric.getKey().equals("new_lines_to_cover")) {
                return counter.getNewLines();
            }
            if (metric.getKey().equals("new_uncovered_lines")) {
                return counter.getNewLines() - counter.getNewCoveredLines();
            }
            if (metric.getKey().equals("new_conditions_to_cover")) {
                return counter.getNewConditions();
            }
            if (metric.getKey().equals("new_uncovered_conditions")) {
                return counter.getNewConditions() - counter.getNewCoveredConditions();
            }
            throw new IllegalArgumentException("Unsupported metric " + metric.getKey());
        }

        @Override
        public String[] getOutputMetricKeys() {
            return new String[]{"new_lines_to_cover", "new_uncovered_lines", "new_conditions_to_cover", "new_uncovered_conditions"};
        }
    }

    private static class NewLineCoverageFormula
    extends SingleWithUncoveredVariationFormula {
        NewLineCoverageFormula() {
            super(new SingleWithUncoveredMetricKeys("new_lines_to_cover", "new_uncovered_lines"), "new_line_coverage");
        }
    }

    private static class NewBranchCoverageFormula
    extends SingleWithUncoveredVariationFormula {
        NewBranchCoverageFormula() {
            super(new SingleWithUncoveredMetricKeys("new_conditions_to_cover", "new_uncovered_conditions"), "new_branch_coverage");
        }
    }

    private static class NewCoverageFormula
    extends LinesAndConditionsWithUncoveredVariationFormula {
        NewCoverageFormula() {
            super(new LinesAndConditionsWithUncoveredMetricKeys("new_lines_to_cover", "new_conditions_to_cover", "new_uncovered_lines", "new_uncovered_conditions"), "new_coverage");
        }
    }
}

