/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.step;

import org.sonar.api.utils.System2;
import org.sonar.ce.task.projectanalysis.analysis.AnalysisMetadataHolder;
import org.sonar.ce.task.projectanalysis.component.Component;
import org.sonar.ce.task.projectanalysis.component.ComponentVisitor;
import org.sonar.ce.task.projectanalysis.component.CrawlerDepthLimit;
import org.sonar.ce.task.projectanalysis.component.DepthTraversalTypeAwareCrawler;
import org.sonar.ce.task.projectanalysis.component.TreeRootHolder;
import org.sonar.ce.task.projectanalysis.component.TypeAwareVisitorAdapter;
import org.sonar.ce.task.projectanalysis.period.Period;
import org.sonar.ce.task.projectanalysis.period.PeriodHolder;
import org.sonar.ce.task.step.ComputationStep;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.SnapshotDto;

public class PersistAnalysisStep
implements ComputationStep {
    private final System2 system2;
    private final DbClient dbClient;
    private final TreeRootHolder treeRootHolder;
    private final AnalysisMetadataHolder analysisMetadataHolder;
    private final PeriodHolder periodHolder;

    public PersistAnalysisStep(System2 system2, DbClient dbClient, TreeRootHolder treeRootHolder, AnalysisMetadataHolder analysisMetadataHolder, PeriodHolder periodHolder) {
        this.system2 = system2;
        this.dbClient = dbClient;
        this.treeRootHolder = treeRootHolder;
        this.analysisMetadataHolder = analysisMetadataHolder;
        this.periodHolder = periodHolder;
    }

    public void execute(ComputationStep.Context context) {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            new DepthTraversalTypeAwareCrawler(new PersistSnapshotsPathAwareVisitor(dbSession, this.analysisMetadataHolder.getAnalysisDate())).visit(this.treeRootHolder.getRoot());
            dbSession.commit();
        }
    }

    public String getDescription() {
        return "Persist analysis";
    }

    private class PersistSnapshotsPathAwareVisitor
    extends TypeAwareVisitorAdapter {
        private final DbSession dbSession;
        private final long analysisDate;

        public PersistSnapshotsPathAwareVisitor(DbSession dbSession, long analysisDate) {
            super(CrawlerDepthLimit.ROOTS, ComponentVisitor.Order.PRE_ORDER);
            this.dbSession = dbSession;
            this.analysisDate = analysisDate;
        }

        @Override
        public void visitProject(Component project) {
            SnapshotDto snapshot = this.createAnalysis(PersistAnalysisStep.this.analysisMetadataHolder.getUuid(), project);
            this.updateSnapshotPeriods(snapshot);
            this.persist(snapshot, this.dbSession);
        }

        @Override
        public void visitView(Component view) {
            SnapshotDto snapshot = this.createAnalysis(PersistAnalysisStep.this.analysisMetadataHolder.getUuid(), view);
            this.updateSnapshotPeriods(snapshot);
            this.persist(snapshot, this.dbSession);
        }

        private void updateSnapshotPeriods(SnapshotDto snapshotDto) {
            if (!PersistAnalysisStep.this.periodHolder.hasPeriod()) {
                return;
            }
            Period period = PersistAnalysisStep.this.periodHolder.getPeriod();
            snapshotDto.setPeriodMode(period.getMode());
            snapshotDto.setPeriodParam(period.getModeParameter());
            snapshotDto.setPeriodDate(Long.valueOf(period.getSnapshotDate()));
        }

        private SnapshotDto createAnalysis(String snapshotUuid, Component component) {
            String componentUuid = component.getUuid();
            String projectVersion = component.getType() == Component.Type.PROJECT ? component.getProjectAttributes().getProjectVersion() : null;
            String buildString = component.getType() == Component.Type.PROJECT ? (String)component.getProjectAttributes().getBuildString().orElse(null) : null;
            return new SnapshotDto().setUuid(snapshotUuid).setProjectVersion(projectVersion).setBuildString(buildString).setComponentUuid(componentUuid).setLast(Boolean.valueOf(false)).setStatus("U").setCreatedAt(Long.valueOf(this.analysisDate)).setBuildDate(Long.valueOf(PersistAnalysisStep.this.system2.now()));
        }

        private void persist(SnapshotDto snapshotDto, DbSession dbSession) {
            PersistAnalysisStep.this.dbClient.snapshotDao().insert(dbSession, snapshotDto);
        }
    }
}

