/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.step;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.sonar.ce.task.projectanalysis.analysis.AnalysisMetadataHolder;
import org.sonar.ce.task.projectanalysis.batch.BatchReportReader;
import org.sonar.ce.task.projectanalysis.component.Component;
import org.sonar.ce.task.projectanalysis.component.TreeRootHolder;
import org.sonar.ce.task.step.ComputationStep;
import org.sonar.core.util.UuidFactory;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.ProjectLinkDto;
import org.sonar.scanner.protocol.output.ScannerReport;

public class PersistProjectLinksStep
implements ComputationStep {
    private final AnalysisMetadataHolder analysisMetadataHolder;
    private final DbClient dbClient;
    private final TreeRootHolder treeRootHolder;
    private final BatchReportReader reportReader;
    private final UuidFactory uuidFactory;
    private static final Map<ScannerReport.ComponentLink.ComponentLinkType, String> typesConverter = ImmutableMap.of((Object)ScannerReport.ComponentLink.ComponentLinkType.HOME, (Object)"homepage", (Object)ScannerReport.ComponentLink.ComponentLinkType.SCM, (Object)"scm", (Object)ScannerReport.ComponentLink.ComponentLinkType.CI, (Object)"ci", (Object)ScannerReport.ComponentLink.ComponentLinkType.ISSUE, (Object)"issue");

    public PersistProjectLinksStep(AnalysisMetadataHolder analysisMetadataHolder, DbClient dbClient, TreeRootHolder treeRootHolder, BatchReportReader reportReader, UuidFactory uuidFactory) {
        this.analysisMetadataHolder = analysisMetadataHolder;
        this.dbClient = dbClient;
        this.treeRootHolder = treeRootHolder;
        this.reportReader = reportReader;
        this.uuidFactory = uuidFactory;
    }

    public void execute(ComputationStep.Context context) {
        if (!this.analysisMetadataHolder.getBranch().isMain()) {
            return;
        }
        try (DbSession session = this.dbClient.openSession(false);){
            Component project = this.treeRootHolder.getRoot();
            ScannerReport.Component batchComponent = this.reportReader.readComponent(project.getReportAttributes().getRef());
            List previousLinks = this.dbClient.projectLinkDao().selectByProjectUuid(session, project.getUuid());
            this.mergeLinks(session, project.getUuid(), batchComponent.getLinkList(), previousLinks);
            session.commit();
        }
    }

    private void mergeLinks(DbSession session, String componentUuid, List<ScannerReport.ComponentLink> links, List<ProjectLinkDto> previousLinks) {
        HashSet linkType = new HashSet();
        links.forEach(link -> {
            String type = PersistProjectLinksStep.convertType(link.getType());
            Preconditions.checkArgument((!linkType.contains(type) ? 1 : 0) != 0, (String)"Link of type '%s' has already been declared on component '%s'", (Object[])new Object[]{type, componentUuid});
            linkType.add(type);
            Optional<ProjectLinkDto> previousLink = previousLinks.stream().filter(input -> input != null && input.getType().equals(PersistProjectLinksStep.convertType(link.getType()))).findFirst();
            if (previousLink.isPresent()) {
                previousLink.get().setHref(link.getHref());
                this.dbClient.projectLinkDao().update(session, previousLink.get());
            } else {
                this.dbClient.projectLinkDao().insert(session, new ProjectLinkDto().setUuid(this.uuidFactory.create()).setProjectUuid(componentUuid).setType(type).setHref(link.getHref()));
            }
        });
        previousLinks.stream().filter(dto -> !linkType.contains(dto.getType())).filter(dto -> ProjectLinkDto.PROVIDED_TYPES.contains(dto.getType())).forEach(dto -> this.dbClient.projectLinkDao().delete(session, dto.getUuid()));
    }

    private static String convertType(ScannerReport.ComponentLink.ComponentLinkType reportType) {
        String type = typesConverter.get(reportType);
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (String)"Unsupported type %s", (Object[])new Object[]{reportType.name()});
        return type;
    }

    public String getDescription() {
        return "Persist project links";
    }
}

