/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.step;

import java.util.Optional;
import javax.annotation.Nullable;
import org.sonar.api.notifications.Notification;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.ce.task.projectanalysis.analysis.AnalysisMetadataHolder;
import org.sonar.ce.task.projectanalysis.analysis.Branch;
import org.sonar.ce.task.projectanalysis.component.Component;
import org.sonar.ce.task.projectanalysis.component.ComponentVisitor;
import org.sonar.ce.task.projectanalysis.component.CrawlerDepthLimit;
import org.sonar.ce.task.projectanalysis.component.DepthTraversalTypeAwareCrawler;
import org.sonar.ce.task.projectanalysis.component.TreeRootHolder;
import org.sonar.ce.task.projectanalysis.component.TypeAwareVisitorAdapter;
import org.sonar.ce.task.projectanalysis.event.Event;
import org.sonar.ce.task.projectanalysis.event.EventRepository;
import org.sonar.ce.task.projectanalysis.measure.Measure;
import org.sonar.ce.task.projectanalysis.measure.MeasureRepository;
import org.sonar.ce.task.projectanalysis.measure.QualityGateStatus;
import org.sonar.ce.task.projectanalysis.metric.Metric;
import org.sonar.ce.task.projectanalysis.metric.MetricRepository;
import org.sonar.ce.task.step.ComputationStep;
import org.sonar.server.notification.NotificationService;

public class QualityGateEventsStep
implements ComputationStep {
    private static final Logger LOGGER = Loggers.get(QualityGateEventsStep.class);
    private final TreeRootHolder treeRootHolder;
    private final MetricRepository metricRepository;
    private final MeasureRepository measureRepository;
    private final EventRepository eventRepository;
    private final NotificationService notificationService;
    private final AnalysisMetadataHolder analysisMetadataHolder;

    public QualityGateEventsStep(TreeRootHolder treeRootHolder, MetricRepository metricRepository, MeasureRepository measureRepository, EventRepository eventRepository, NotificationService notificationService, AnalysisMetadataHolder analysisMetadataHolder) {
        this.treeRootHolder = treeRootHolder;
        this.metricRepository = metricRepository;
        this.measureRepository = measureRepository;
        this.eventRepository = eventRepository;
        this.notificationService = notificationService;
        this.analysisMetadataHolder = analysisMetadataHolder;
    }

    public void execute(ComputationStep.Context context) {
        if (this.analysisMetadataHolder.isSLBorPR()) {
            return;
        }
        new DepthTraversalTypeAwareCrawler(new TypeAwareVisitorAdapter(CrawlerDepthLimit.PROJECT, ComponentVisitor.Order.PRE_ORDER){

            @Override
            public void visitProject(Component project) {
                QualityGateEventsStep.this.executeForProject(project);
            }
        }).visit(this.treeRootHolder.getRoot());
    }

    private void executeForProject(Component project) {
        Metric metric = this.metricRepository.getByKey("alert_status");
        Optional<Measure> rawStatus = this.measureRepository.getRawMeasure(project, metric);
        if (!rawStatus.isPresent() || !rawStatus.get().hasQualityGateStatus()) {
            return;
        }
        this.checkQualityGateStatusChange(project, metric, rawStatus.get().getQualityGateStatus());
    }

    private void checkQualityGateStatusChange(Component project, Metric metric, QualityGateStatus rawStatus) {
        Optional<Measure> baseMeasure = this.measureRepository.getBaseMeasure(project, metric);
        if (!baseMeasure.isPresent()) {
            this.checkNewQualityGate(project, rawStatus);
            return;
        }
        if (!baseMeasure.get().hasQualityGateStatus()) {
            LOGGER.warn(String.format("Previous Quality gate status for project %s is not a supported value. Can not compute Quality Gate event", project.getDbKey()));
            this.checkNewQualityGate(project, rawStatus);
            return;
        }
        QualityGateStatus baseStatus = baseMeasure.get().getQualityGateStatus();
        if (baseStatus.getStatus() != rawStatus.getStatus()) {
            String label = String.format("%s (was %s)", rawStatus.getStatus().getColorName(), baseStatus.getStatus().getColorName());
            this.createEvent(project, label, rawStatus.getText());
            boolean isNewKo = rawStatus.getStatus() == Measure.Level.OK;
            this.notifyUsers(project, label, rawStatus, isNewKo);
        }
    }

    private void checkNewQualityGate(Component project, QualityGateStatus rawStatus) {
        if (rawStatus.getStatus() != Measure.Level.OK) {
            this.createEvent(project, rawStatus.getStatus().getColorName(), rawStatus.getText());
            this.notifyUsers(project, rawStatus.getStatus().getColorName(), rawStatus, true);
        }
    }

    private void notifyUsers(Component project, String label, QualityGateStatus rawStatus, boolean isNewAlert) {
        Notification notification = new Notification("alerts").setDefaultMessage(String.format("Alert on %s: %s", project.getName(), label)).setFieldValue("projectName", project.getName()).setFieldValue("projectKey", project.getKey()).setFieldValue("projectVersion", project.getProjectAttributes().getProjectVersion()).setFieldValue("alertName", label).setFieldValue("alertText", rawStatus.getText()).setFieldValue("alertLevel", rawStatus.getStatus().toString()).setFieldValue("isNewAlert", Boolean.toString(isNewAlert));
        Branch branch = this.analysisMetadataHolder.getBranch();
        if (!branch.isMain()) {
            notification.setFieldValue("branch", branch.getName());
        }
        this.notificationService.deliver(notification);
    }

    private void createEvent(Component project, String name, @Nullable String description) {
        this.eventRepository.add(project, Event.createAlert(name, null, description));
    }

    public String getDescription() {
        return "Generate Quality gate events";
    }
}

